/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.keyspace;

import com.datastax.driver.core.DataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.keyspace.AddColumnSpecification;
import org.springframework.cassandra.core.keyspace.AlterColumnSpecification;
import org.springframework.cassandra.core.keyspace.ColumnChangeSpecification;
import org.springframework.cassandra.core.keyspace.DropColumnSpecification;
import org.springframework.cassandra.core.keyspace.RenameColumnSpecification;
import org.springframework.cassandra.core.keyspace.TableOptionsSpecification;

public class AlterTableSpecification
extends TableOptionsSpecification<AlterTableSpecification> {
    private List<ColumnChangeSpecification> changes = new ArrayList<ColumnChangeSpecification>();

    public static AlterTableSpecification alterTable() {
        return new AlterTableSpecification();
    }

    public static AlterTableSpecification alterTable(CqlIdentifier tableName) {
        return (AlterTableSpecification)new AlterTableSpecification().name(tableName);
    }

    public static AlterTableSpecification alterTable(String tableName) {
        return (AlterTableSpecification)new AlterTableSpecification().name(tableName);
    }

    public AlterTableSpecification drop(String column) {
        this.changes.add(new DropColumnSpecification(column));
        return this;
    }

    public AlterTableSpecification add(String column, DataType type) {
        this.changes.add(new AddColumnSpecification(column, type));
        return this;
    }

    public AlterTableSpecification rename(String from, String to) {
        this.changes.add(new RenameColumnSpecification(from, to));
        return this;
    }

    public AlterTableSpecification alter(String column, DataType type) {
        this.changes.add(new AlterColumnSpecification(column, type));
        return this;
    }

    public List<ColumnChangeSpecification> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }
}

