/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.cql.generator;

import org.springframework.cassandra.core.cql.CqlStringUtils;
import org.springframework.cassandra.core.cql.generator.AddColumnCqlGenerator;
import org.springframework.cassandra.core.cql.generator.AlterColumnCqlGenerator;
import org.springframework.cassandra.core.cql.generator.ColumnChangeCqlGenerator;
import org.springframework.cassandra.core.cql.generator.RenameColumnCqlGenerator;
import org.springframework.cassandra.core.cql.generator.UserTypeNameCqlGenerator;
import org.springframework.cassandra.core.keyspace.AddColumnSpecification;
import org.springframework.cassandra.core.keyspace.AlterColumnSpecification;
import org.springframework.cassandra.core.keyspace.AlterUserTypeSpecification;
import org.springframework.cassandra.core.keyspace.ColumnChangeSpecification;
import org.springframework.cassandra.core.keyspace.RenameColumnSpecification;
import org.springframework.util.Assert;

public class AlterUserTypeCqlGenerator
extends UserTypeNameCqlGenerator<AlterUserTypeSpecification> {
    public static String toCql(AlterUserTypeSpecification specification) {
        return new AlterUserTypeCqlGenerator(specification).toCql();
    }

    public AlterUserTypeCqlGenerator(AlterUserTypeSpecification specification) {
        super(specification);
    }

    @Override
    public StringBuilder toCql(StringBuilder cql) {
        Assert.notNull((Object)((AlterUserTypeSpecification)this.getSpecification()).getName(), (String)"User type name must not be null");
        Assert.isTrue((!((AlterUserTypeSpecification)this.getSpecification()).getChanges().isEmpty() ? 1 : 0) != 0, (String)String.format("User type [%s] does not contain fields", ((AlterUserTypeSpecification)this.getSpecification()).getName()));
        return this.changesCql(this.preambleCql(cql)).append(";");
    }

    private StringBuilder preambleCql(StringBuilder cql) {
        return CqlStringUtils.noNull(cql).append("ALTER TYPE ").append(((AlterUserTypeSpecification)this.spec()).getName()).append(' ');
    }

    private StringBuilder changesCql(StringBuilder cql) {
        cql = CqlStringUtils.noNull(cql);
        boolean first = true;
        boolean lastChangeWasRename = false;
        for (ColumnChangeSpecification change : ((AlterUserTypeSpecification)this.spec()).getChanges()) {
            if (!first) {
                cql.append(' ');
            }
            this.getCqlGeneratorFor(change, lastChangeWasRename).toCql(cql);
            lastChangeWasRename = change instanceof RenameColumnSpecification;
            first = false;
        }
        return cql;
    }

    private ColumnChangeCqlGenerator<?> getCqlGeneratorFor(ColumnChangeSpecification change, boolean lastChangeWasRename) {
        if (change instanceof AddColumnSpecification) {
            return new AddColumnCqlGenerator((AddColumnSpecification)change);
        }
        if (change instanceof AlterColumnSpecification) {
            return new AlterColumnCqlGenerator((AlterColumnSpecification)change);
        }
        if (change instanceof RenameColumnSpecification) {
            return new RenameColumnCqlGenerator(lastChangeWasRename ? "AND" : "RENAME", change);
        }
        throw new IllegalArgumentException(String.format("Unknown ColumnChangeSpecification type: %s", change.getClass().getName()));
    }
}

