/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.converter;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public class ResultSetToArrayConverter
implements Converter<ResultSet, Object[]> {
    protected Converter<Row, Object[]> rowConverter;

    public ResultSetToArrayConverter(Converter<Row, Object[]> rowConverter) {
        this.setRowConverter(rowConverter);
    }

    public Converter<Row, Object[]> getRowConverter() {
        return this.rowConverter;
    }

    public void setRowConverter(Converter<Row, Object[]> rowConverter) {
        Assert.notNull(rowConverter, (String)"Converter must not be null");
        this.rowConverter = rowConverter;
    }

    public Object[] convert(ResultSet resultSet) {
        if (resultSet == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator i = resultSet.iterator();
        while (i.hasNext()) {
            list.add(this.rowConverter.convert(i.next()));
        }
        return list.toArray();
    }
}

