/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core;

import java.util.concurrent.TimeUnit;
import org.springframework.cassandra.core.ConsistencyLevel;
import org.springframework.cassandra.core.QueryOptions;
import org.springframework.cassandra.core.RetryPolicy;

public class WriteOptions
extends QueryOptions {
    private Integer ttl;

    public WriteOptions() {
    }

    public WriteOptions(ConsistencyLevel consistencyLevel, RetryPolicy retryPolicy) {
        this(consistencyLevel, retryPolicy, null);
    }

    public WriteOptions(ConsistencyLevel consistencyLevel, RetryPolicy retryPolicy, Integer ttl) {
        super(consistencyLevel, retryPolicy);
        this.setTtl(ttl);
    }

    public static WriteOptionsBuilder builder() {
        return new WriteOptionsBuilder();
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public static class WriteOptionsBuilder
    extends QueryOptions.QueryOptionsBuilder {
        private Integer ttl;

        private WriteOptionsBuilder() {
        }

        @Override
        public WriteOptionsBuilder consistencyLevel(com.datastax.driver.core.ConsistencyLevel driverConsistencyLevel) {
            return (WriteOptionsBuilder)super.consistencyLevel(driverConsistencyLevel);
        }

        @Override
        public WriteOptionsBuilder retryPolicy(com.datastax.driver.core.policies.RetryPolicy driverRetryPolicy) {
            return (WriteOptionsBuilder)super.retryPolicy(driverRetryPolicy);
        }

        @Override
        public WriteOptionsBuilder retryPolicy(RetryPolicy retryPolicy) {
            return (WriteOptionsBuilder)super.retryPolicy(retryPolicy);
        }

        @Override
        public WriteOptionsBuilder fetchSize(int fetchSize) {
            return (WriteOptionsBuilder)super.fetchSize(fetchSize);
        }

        @Override
        public WriteOptionsBuilder readTimeout(long readTimeout) {
            return (WriteOptionsBuilder)super.readTimeout(readTimeout);
        }

        @Override
        public WriteOptionsBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
            return (WriteOptionsBuilder)super.readTimeout(readTimeout, timeUnit);
        }

        @Override
        public WriteOptionsBuilder tracing(boolean tracing) {
            return (WriteOptionsBuilder)super.tracing(tracing);
        }

        @Override
        public WriteOptionsBuilder withTracing() {
            return (WriteOptionsBuilder)super.withTracing();
        }

        public WriteOptionsBuilder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        @Override
        public WriteOptions build() {
            WriteOptions queryOptions = this.applyOptions(new WriteOptions());
            queryOptions.setTtl(this.ttl);
            return queryOptions;
        }
    }
}

