/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core;

import java.util.concurrent.TimeUnit;
import org.springframework.cassandra.core.ConsistencyLevel;
import org.springframework.cassandra.core.RetryPolicy;
import org.springframework.util.Assert;

public class QueryOptions {
    private ConsistencyLevel consistencyLevel;
    private com.datastax.driver.core.ConsistencyLevel driverConsistencyLevel;
    private RetryPolicy retryPolicy;
    private com.datastax.driver.core.policies.RetryPolicy driverRetryPolicy;
    private Boolean tracing;
    private Integer fetchSize;
    private Long readTimeout;

    public QueryOptions() {
    }

    public QueryOptions(ConsistencyLevel consistencyLevel, RetryPolicy retryPolicy) {
        this.setConsistencyLevel(consistencyLevel);
        this.setRetryPolicy(retryPolicy);
    }

    public static QueryOptionsBuilder builder() {
        return new QueryOptionsBuilder();
    }

    @Deprecated
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        if (this.driverConsistencyLevel != null && consistencyLevel != null) {
            throw new IllegalStateException("ConsistencyLevel cannot not be set if the Driver ConsistencyLevel is already set");
        }
        this.consistencyLevel = consistencyLevel;
    }

    public void setConsistencyLevel(com.datastax.driver.core.ConsistencyLevel driverConsistencyLevel) {
        if (this.consistencyLevel != null && driverConsistencyLevel != null) {
            throw new IllegalStateException("Driver ConsistencyLevel cannot not be set if the ConsistencyLevel is already set");
        }
        this.driverConsistencyLevel = driverConsistencyLevel;
    }

    protected com.datastax.driver.core.ConsistencyLevel getDriverConsistencyLevel() {
        return this.driverConsistencyLevel;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        if (this.driverRetryPolicy != null && retryPolicy != null) {
            throw new IllegalStateException("RetryPolicy cannot not be set if the Driver RetryPolicy is already set");
        }
        this.retryPolicy = retryPolicy;
    }

    public void setRetryPolicy(com.datastax.driver.core.policies.RetryPolicy driverRetryPolicy) {
        if (this.retryPolicy != null && driverRetryPolicy != null) {
            throw new IllegalStateException("Driver RetryPolicy cannot not be set if the RetryPolicy is already set");
        }
        this.driverRetryPolicy = driverRetryPolicy;
    }

    protected com.datastax.driver.core.policies.RetryPolicy getDriverRetryPolicy() {
        return this.driverRetryPolicy;
    }

    public void setFetchSize(int fetchSize) {
        Assert.isTrue((fetchSize >= 0 ? 1 : 0) != 0, (String)"FetchSize must be greater than equal to zero");
        this.fetchSize = fetchSize;
    }

    protected Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setReadTimeout(long readTimeout) {
        Assert.isTrue((readTimeout >= 0L ? 1 : 0) != 0, (String)"ReadTimeout must be greater than equal to zero");
        this.readTimeout = readTimeout;
    }

    protected Long getReadTimeout() {
        return this.readTimeout;
    }

    public void setTracing(boolean tracing) {
        this.tracing = tracing;
    }

    protected Boolean getTracing() {
        return this.tracing;
    }

    public static class QueryOptionsBuilder {
        private com.datastax.driver.core.ConsistencyLevel driverConsistencyLevel;
        private RetryPolicy retryPolicy;
        private com.datastax.driver.core.policies.RetryPolicy driverRetryPolicy;
        private Boolean tracing;
        private Integer fetchSize;
        private Long readTimeout;

        QueryOptionsBuilder() {
        }

        public QueryOptionsBuilder consistencyLevel(com.datastax.driver.core.ConsistencyLevel driverConsistencyLevel) {
            Assert.notNull((Object)driverConsistencyLevel, (String)"Driver ConsistencyLevel must not be null");
            this.driverConsistencyLevel = driverConsistencyLevel;
            return this;
        }

        public QueryOptionsBuilder retryPolicy(RetryPolicy retryPolicy) {
            Assert.notNull((Object)((Object)retryPolicy), (String)"RetryPolicy must not be null");
            Assert.state((this.driverRetryPolicy == null ? 1 : 0) != 0, (String)"RetryPolicy cannot not be set if the Driver RetryPolicy is already set");
            this.retryPolicy = retryPolicy;
            return this;
        }

        public QueryOptionsBuilder retryPolicy(com.datastax.driver.core.policies.RetryPolicy driverRetryPolicy) {
            Assert.notNull((Object)driverRetryPolicy, (String)"Driver RetryPolicy must not be null");
            Assert.state((this.retryPolicy == null ? 1 : 0) != 0, (String)"Driver RetryPolicy cannot not be set if the RetryPolicy is already set");
            this.driverRetryPolicy = driverRetryPolicy;
            return this;
        }

        public QueryOptionsBuilder fetchSize(int fetchSize) {
            Assert.isTrue((fetchSize >= 0 ? 1 : 0) != 0, (String)"FetchSize must be greater or equal to zero");
            this.fetchSize = fetchSize;
            return this;
        }

        public QueryOptionsBuilder readTimeout(long readTimeout) {
            Assert.isTrue((readTimeout >= 0L ? 1 : 0) != 0, (String)"ReadTimeout must be greater or equal to zero");
            this.readTimeout = readTimeout;
            return this;
        }

        public QueryOptionsBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
            Assert.isTrue((readTimeout >= 0L ? 1 : 0) != 0, (String)"ReadTimeout must be greater or equal to zero");
            Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null");
            this.readTimeout = timeUnit.toMillis(readTimeout);
            return this;
        }

        public QueryOptionsBuilder tracing(boolean tracing) {
            this.tracing = tracing;
            return this;
        }

        public QueryOptionsBuilder withTracing() {
            return this.tracing(true);
        }

        public QueryOptions build() {
            return this.applyOptions(new QueryOptions());
        }

        <T extends QueryOptions> T applyOptions(T queryOptions) {
            queryOptions.setConsistencyLevel(this.driverConsistencyLevel);
            queryOptions.setRetryPolicy(this.retryPolicy);
            queryOptions.setRetryPolicy(this.driverRetryPolicy);
            if (this.fetchSize != null) {
                queryOptions.setFetchSize(this.fetchSize);
            }
            if (this.readTimeout != null) {
                queryOptions.setReadTimeout(this.readTimeout);
            }
            if (this.tracing != null) {
                queryOptions.setTracing(this.tracing);
            }
            return queryOptions;
        }
    }
}

