/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.keyspace;

import com.datastax.driver.core.DataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.cassandra.core.Ordering;
import org.springframework.cassandra.core.PrimaryKeyType;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.keyspace.ColumnSpecification;
import org.springframework.cassandra.core.keyspace.TableDescriptor;
import org.springframework.cassandra.core.keyspace.TableOptionsSpecification;

public class TableSpecification<T>
extends TableOptionsSpecification<TableSpecification<T>>
implements TableDescriptor {
    private List<ColumnSpecification> columns = new ArrayList<ColumnSpecification>();
    private List<ColumnSpecification> partitionKeyColumns = new ArrayList<ColumnSpecification>();
    private List<ColumnSpecification> clusteredKeyColumns = new ArrayList<ColumnSpecification>();
    private List<ColumnSpecification> nonKeyColumns = new ArrayList<ColumnSpecification>();

    public T column(String name, DataType type) {
        return this.column(CqlIdentifier.cqlId(name), type);
    }

    public T column(CqlIdentifier name, DataType type) {
        return this.column(name, type, null, null);
    }

    public T partitionKeyColumn(String name, DataType type) {
        return this.partitionKeyColumn(CqlIdentifier.cqlId(name), type);
    }

    public T partitionKeyColumn(CqlIdentifier name, DataType type) {
        return this.column(name, type, PrimaryKeyType.PARTITIONED, null);
    }

    public T clusteredKeyColumn(String name, DataType type) {
        return this.clusteredKeyColumn(name, type, null);
    }

    public T clusteredKeyColumn(CqlIdentifier name, DataType type) {
        return this.clusteredKeyColumn(name, type, null);
    }

    public T clusteredKeyColumn(String name, DataType type, Ordering ordering) {
        return this.clusteredKeyColumn(CqlIdentifier.cqlId(name), type, ordering);
    }

    public T clusteredKeyColumn(CqlIdentifier name, DataType type, Ordering ordering) {
        return this.column(name, type, PrimaryKeyType.CLUSTERED, ordering);
    }

    protected T column(String name, DataType type, PrimaryKeyType keyType, Ordering ordering) {
        return this.column(CqlIdentifier.cqlId(name), type, keyType, ordering);
    }

    protected T column(CqlIdentifier name, DataType type, PrimaryKeyType keyType, Ordering ordering) {
        ColumnSpecification column = new ColumnSpecification().name(name).type(type).keyType(keyType).ordering(keyType == PrimaryKeyType.CLUSTERED ? ordering : null);
        this.columns.add(column);
        if (keyType == PrimaryKeyType.PARTITIONED) {
            this.partitionKeyColumns.add(column);
        }
        if (keyType == PrimaryKeyType.CLUSTERED) {
            this.clusteredKeyColumns.add(column);
        }
        if (keyType == null) {
            this.nonKeyColumns.add(column);
        }
        return (T)this;
    }

    @Override
    public List<ColumnSpecification> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public List<ColumnSpecification> getPartitionKeyColumns() {
        return Collections.unmodifiableList(this.partitionKeyColumns);
    }

    @Override
    public List<ColumnSpecification> getClusteredKeyColumns() {
        return Collections.unmodifiableList(this.clusteredKeyColumns);
    }

    @Override
    public List<ColumnSpecification> getPrimaryKeyColumns() {
        ArrayList<ColumnSpecification> primaryKeyColumns = new ArrayList<ColumnSpecification>();
        primaryKeyColumns.addAll(this.partitionKeyColumns);
        primaryKeyColumns.addAll(this.clusteredKeyColumns);
        return Collections.unmodifiableList(primaryKeyColumns);
    }

    @Override
    public List<ColumnSpecification> getNonKeyColumns() {
        return Collections.unmodifiableList(this.nonKeyColumns);
    }
}

