/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.config;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cassandra.core.CqlTemplate;
import org.springframework.cassandra.support.CassandraExceptionTranslator;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CassandraCqlSessionFactoryBean
implements FactoryBean<Session>,
InitializingBean,
DisposableBean,
PersistenceExceptionTranslator {
    private static final Logger log = LoggerFactory.getLogger(CassandraCqlSessionFactoryBean.class);
    protected Cluster cluster;
    protected Session session;
    protected String keyspaceName;
    protected List<String> startupScripts = new ArrayList<String>();
    protected List<String> shutdownScripts = new ArrayList<String>();
    protected final PersistenceExceptionTranslator exceptionTranslator = new CassandraExceptionTranslator();

    public Session getObject() {
        return this.session;
    }

    public Class<? extends Session> getObjectType() {
        return Session.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cluster);
        this.session = StringUtils.hasText((String)this.keyspaceName) ? this.cluster.connect(this.keyspaceName) : this.cluster.connect();
        this.executeScripts(this.startupScripts);
    }

    protected void executeScripts(List<String> scripts) {
        if (scripts == null || scripts.size() == 0) {
            return;
        }
        CqlTemplate template = new CqlTemplate(this.session);
        for (String script : scripts) {
            if (log.isInfoEnabled()) {
                log.info("executing raw CQL [{}]", (Object)script);
            }
            template.execute(script);
        }
    }

    public void destroy() throws Exception {
        this.executeScripts(this.shutdownScripts);
        this.session.close();
    }

    public void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    public void setCluster(Cluster cluster) {
        if (cluster == null) {
            throw new IllegalArgumentException("cluster must not be null");
        }
        this.cluster = cluster;
    }

    public void setStartupScripts(List<String> scripts) {
        this.startupScripts = scripts == null ? new ArrayList<String>() : new ArrayList<String>(scripts);
    }

    public List<String> getStartupScripts() {
        return Collections.unmodifiableList(this.startupScripts);
    }

    public void setShutdownScripts(List<String> scripts) {
        this.shutdownScripts = scripts == null ? new ArrayList<String>() : new ArrayList<String>(scripts);
    }

    public List<String> getShutdownScripts() {
        return Collections.unmodifiableList(this.shutdownScripts);
    }
}

