/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.serviceregistry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.serviceregistry.AbstractAutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.serviceregistry.ZookeeperRegistration;
import org.springframework.cloud.zookeeper.serviceregistry.ZookeeperServiceRegistry;

public class ZookeeperAutoServiceRegistration
extends AbstractAutoServiceRegistration<ZookeeperRegistration> {
    private static final Log log = LogFactory.getLog(ZookeeperAutoServiceRegistration.class);
    private ZookeeperRegistration registration;
    private ZookeeperDiscoveryProperties properties;

    public ZookeeperAutoServiceRegistration(ZookeeperServiceRegistry registry, ZookeeperRegistration registration, ZookeeperDiscoveryProperties properties) {
        this(registry, registration, properties, null);
    }

    public ZookeeperAutoServiceRegistration(ZookeeperServiceRegistry registry, ZookeeperRegistration registration, ZookeeperDiscoveryProperties properties, AutoServiceRegistrationProperties arProperties) {
        super((ServiceRegistry)registry, arProperties);
        this.registration = registration;
        this.properties = properties;
        if (this.properties.getInstancePort() != null) {
            this.registration.setPort(this.properties.getInstancePort());
        }
    }

    protected ZookeeperRegistration getRegistration() {
        return this.registration;
    }

    protected ZookeeperRegistration getManagementRegistration() {
        return null;
    }

    protected void register() {
        if (!this.properties.isRegister()) {
            log.debug((Object)"Registration disabled.");
            return;
        }
        if (this.registration.getPort() == 0) {
            this.registration.setPort(this.getPort().get());
        }
        super.register();
    }

    protected void deregister() {
        if (!this.properties.isRegister()) {
            return;
        }
        super.deregister();
    }

    protected boolean isEnabled() {
        return this.properties.isEnabled();
    }

    protected Object getConfiguration() {
        return this.properties;
    }
}

