/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import com.netflix.loadbalancer.Server;
import java.util.Map;
import org.apache.curator.x.discovery.ServiceInstance;
import org.springframework.cloud.netflix.ribbon.DefaultServerIntrospector;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServer;

public class ZookeeperServerIntrospector
extends DefaultServerIntrospector {
    public boolean isSecure(Server server) {
        if (server instanceof ZookeeperServer) {
            ZookeeperServer zookeeperServer = (ZookeeperServer)server;
            Integer sslPort = zookeeperServer.getInstance().getSslPort();
            return sslPort != null && sslPort > 0;
        }
        return super.isSecure(server);
    }

    public Map<String, String> getMetadata(Server server) {
        ZookeeperServer zookeeperServer;
        ServiceInstance<ZookeeperInstance> instance;
        if (server instanceof ZookeeperServer && (instance = (zookeeperServer = (ZookeeperServer)server).getInstance()) != null && instance.getPayload() != null) {
            return ((ZookeeperInstance)instance.getPayload()).getMetadata();
        }
        return super.getMetadata(server);
    }
}

