/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.UriSpec;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ZookeeperServiceDiscovery
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private CuratorFramework curator;
    private ZookeeperDiscoveryProperties properties;
    private InstanceSerializer<ZookeeperInstance> instanceSerializer;
    private ApplicationContext context;
    private AtomicBoolean built = new AtomicBoolean(false);
    private AtomicInteger port = new AtomicInteger();
    private AtomicReference<ServiceInstance<ZookeeperInstance>> serviceInstance = new AtomicReference();
    private AtomicReference<ServiceDiscovery<ZookeeperInstance>> serviceDiscovery = new AtomicReference();
    @Value(value="${spring.application.name:application}")
    private String appName;

    public ZookeeperServiceDiscovery(CuratorFramework curator, ZookeeperDiscoveryProperties properties, InstanceSerializer<ZookeeperInstance> instanceSerializer) {
        this.curator = curator;
        this.properties = properties;
        this.instanceSerializer = instanceSerializer;
    }

    public int getPort() {
        return this.port.get();
    }

    public void setPort(int port) {
        this.port.set(port);
    }

    public ServiceInstance<ZookeeperInstance> getServiceInstance() {
        return this.serviceInstance.get();
    }

    public ServiceDiscovery<ZookeeperInstance> getServiceDiscovery() {
        return this.serviceDiscovery.get();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void build() {
        if (this.built.compareAndSet(false, true)) {
            if (this.port.get() <= 0 && this.properties.isRegister()) {
                throw new IllegalStateException("Cannot create instance whose port is not greater than 0");
            }
            String host = this.properties.getInstanceHost();
            if (!StringUtils.hasText((String)host)) {
                throw new IllegalStateException("instanceHost must not be empty");
            }
            UriSpec uriSpec = new UriSpec(this.properties.getUriSpec());
            if (this.properties.isRegister()) {
                this.configureServiceInstance(this.serviceInstance, this.appName, this.context, this.port, host, uriSpec);
            }
        }
    }

    public void buildServiceDiscovery() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configuring service discovery for service instance [" + this.serviceInstance + "]"));
        }
        this.configureServiceDiscovery(this.serviceDiscovery, this.curator, this.properties, this.instanceSerializer, this.serviceInstance);
    }

    protected void configureServiceInstance(AtomicReference<ServiceInstance<ZookeeperInstance>> serviceInstance, String appName, ApplicationContext context, AtomicInteger port, String host, UriSpec uriSpec) {
        try {
            serviceInstance.set((ServiceInstance<ZookeeperInstance>)ServiceInstance.builder().name(appName).payload((Object)new ZookeeperInstance(context.getId(), appName, this.properties.getMetadata())).port(port.get()).address(host).uriSpec(uriSpec).build());
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    protected void configureServiceDiscovery(AtomicReference<ServiceDiscovery<ZookeeperInstance>> serviceDiscovery, CuratorFramework curator, ZookeeperDiscoveryProperties properties, InstanceSerializer<ZookeeperInstance> instanceSerializer, AtomicReference<ServiceInstance<ZookeeperInstance>> serviceInstance) {
        serviceDiscovery.set((ServiceDiscovery<ZookeeperInstance>)ServiceDiscoveryBuilder.builder(ZookeeperInstance.class).client(curator).basePath(properties.getRoot()).serializer(instanceSerializer).thisInstance(serviceInstance.get()).build());
    }

    protected AtomicReference<ServiceDiscovery<ZookeeperInstance>> getServiceDiscoveryRef() {
        return this.serviceDiscovery;
    }

    protected AtomicReference<ServiceInstance<ZookeeperInstance>> getServiceInstanceRef() {
        return this.serviceInstance;
    }

    protected AtomicBoolean getBuilt() {
        return this.built;
    }

    protected CuratorFramework getCurator() {
        return this.curator;
    }
}

