/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadataFactory;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptor;

final class SecretBackendFactories {
    private static final Log log = LogFactory.getLog(SecretBackendFactories.class);

    private SecretBackendFactories() {
    }

    static Collection<SecretBackendMetadata> createSecretBackendMetadata(Collection<VaultSecretBackendDescriptor> vaultSecretBackendDescriptors, Collection<SecretBackendMetadataFactory<? super VaultSecretBackendDescriptor>> factories) {
        ArrayList<SecretBackendMetadata> accessors = new ArrayList<SecretBackendMetadata>();
        for (VaultSecretBackendDescriptor vaultSecretBackendDescriptor : vaultSecretBackendDescriptors) {
            if (!vaultSecretBackendDescriptor.isEnabled()) continue;
            SecretBackendMetadata metadata = SecretBackendFactories.createSecretBackendMetadata(factories, vaultSecretBackendDescriptor);
            if (metadata == null) {
                log.warn((Object)String.format("Cannot create SecretBackendMetadata for %s", vaultSecretBackendDescriptor));
                continue;
            }
            accessors.add(metadata);
        }
        return accessors;
    }

    private static SecretBackendMetadata createSecretBackendMetadata(Collection<SecretBackendMetadataFactory<? super VaultSecretBackendDescriptor>> factories, VaultSecretBackendDescriptor vaultSecretBackendDescriptor) {
        SecretBackendMetadata accessor = null;
        for (SecretBackendMetadataFactory<? super VaultSecretBackendDescriptor> factory : factories) {
            if (!factory.supports(vaultSecretBackendDescriptor)) continue;
            accessor = factory.createMetadata(vaultSecretBackendDescriptor);
            break;
        }
        return accessor;
    }
}

