/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.time.Duration;
import javax.validation.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="spring.cloud.vault")
@Validated
public class VaultProperties
implements EnvironmentAware {
    private boolean enabled = true;
    @NotEmpty
    private String host = "localhost";
    @Range(min=1L, max=65535L)
    private @Range(min=1L, max=65535L) int port = 8200;
    private String scheme = "https";
    private String uri;
    private Discovery discovery = new Discovery();
    private int connectionTimeout = 5000;
    private int readTimeout = 15000;
    private boolean failFast = false;
    private String token;
    private AppIdProperties appId = new AppIdProperties();
    private AppRoleProperties appRole = new AppRoleProperties();
    private AwsEc2Properties awsEc2 = new AwsEc2Properties();
    private AwsIamProperties awsIam = new AwsIamProperties();
    private AzureMsiProperties azureMsi = new AzureMsiProperties();
    private GcpGceProperties gcpGce = new GcpGceProperties();
    private GcpIamProperties gcpIam = new GcpIamProperties();
    private KubernetesProperties kubernetes = new KubernetesProperties();
    private Ssl ssl = new Ssl();
    private Config config = new Config();
    private String applicationName = "application";
    private AuthenticationMethod authentication = AuthenticationMethod.TOKEN;

    public void setEnvironment(Environment environment) {
        String springAppName = environment.getProperty("spring.application.name");
        if (StringUtils.hasText((String)springAppName)) {
            this.applicationName = springAppName;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUri() {
        return this.uri;
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public String getToken() {
        return this.token;
    }

    public AppIdProperties getAppId() {
        return this.appId;
    }

    public AppRoleProperties getAppRole() {
        return this.appRole;
    }

    public AwsEc2Properties getAwsEc2() {
        return this.awsEc2;
    }

    public AwsIamProperties getAwsIam() {
        return this.awsIam;
    }

    public AzureMsiProperties getAzureMsi() {
        return this.azureMsi;
    }

    public GcpGceProperties getGcpGce() {
        return this.gcpGce;
    }

    public GcpIamProperties getGcpIam() {
        return this.gcpIam;
    }

    public KubernetesProperties getKubernetes() {
        return this.kubernetes;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public AuthenticationMethod getAuthentication() {
        return this.authentication;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setDiscovery(Discovery discovery) {
        this.discovery = discovery;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setAppId(AppIdProperties appId) {
        this.appId = appId;
    }

    public void setAppRole(AppRoleProperties appRole) {
        this.appRole = appRole;
    }

    public void setAwsEc2(AwsEc2Properties awsEc2) {
        this.awsEc2 = awsEc2;
    }

    public void setAwsIam(AwsIamProperties awsIam) {
        this.awsIam = awsIam;
    }

    public void setAzureMsi(AzureMsiProperties azureMsi) {
        this.azureMsi = azureMsi;
    }

    public void setGcpGce(GcpGceProperties gcpGce) {
        this.gcpGce = gcpGce;
    }

    public void setGcpIam(GcpIamProperties gcpIam) {
        this.gcpIam = gcpIam;
    }

    public void setKubernetes(KubernetesProperties kubernetes) {
        this.kubernetes = kubernetes;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setAuthentication(AuthenticationMethod authentication) {
        this.authentication = authentication;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VaultProperties)) {
            return false;
        }
        VaultProperties other = (VaultProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        Discovery this$discovery = this.getDiscovery();
        Discovery other$discovery = other.getDiscovery();
        if (this$discovery == null ? other$discovery != null : !((Object)this$discovery).equals(other$discovery)) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.isFailFast() != other.isFailFast()) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        AppIdProperties this$appId = this.getAppId();
        AppIdProperties other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
            return false;
        }
        AppRoleProperties this$appRole = this.getAppRole();
        AppRoleProperties other$appRole = other.getAppRole();
        if (this$appRole == null ? other$appRole != null : !((Object)this$appRole).equals(other$appRole)) {
            return false;
        }
        AwsEc2Properties this$awsEc2 = this.getAwsEc2();
        AwsEc2Properties other$awsEc2 = other.getAwsEc2();
        if (this$awsEc2 == null ? other$awsEc2 != null : !((Object)this$awsEc2).equals(other$awsEc2)) {
            return false;
        }
        AwsIamProperties this$awsIam = this.getAwsIam();
        AwsIamProperties other$awsIam = other.getAwsIam();
        if (this$awsIam == null ? other$awsIam != null : !((Object)this$awsIam).equals(other$awsIam)) {
            return false;
        }
        AzureMsiProperties this$azureMsi = this.getAzureMsi();
        AzureMsiProperties other$azureMsi = other.getAzureMsi();
        if (this$azureMsi == null ? other$azureMsi != null : !((Object)this$azureMsi).equals(other$azureMsi)) {
            return false;
        }
        GcpGceProperties this$gcpGce = this.getGcpGce();
        GcpGceProperties other$gcpGce = other.getGcpGce();
        if (this$gcpGce == null ? other$gcpGce != null : !((Object)this$gcpGce).equals(other$gcpGce)) {
            return false;
        }
        GcpIamProperties this$gcpIam = this.getGcpIam();
        GcpIamProperties other$gcpIam = other.getGcpIam();
        if (this$gcpIam == null ? other$gcpIam != null : !((Object)this$gcpIam).equals(other$gcpIam)) {
            return false;
        }
        KubernetesProperties this$kubernetes = this.getKubernetes();
        KubernetesProperties other$kubernetes = other.getKubernetes();
        if (this$kubernetes == null ? other$kubernetes != null : !((Object)this$kubernetes).equals(other$kubernetes)) {
            return false;
        }
        Ssl this$ssl = this.getSsl();
        Ssl other$ssl = other.getSsl();
        if (this$ssl == null ? other$ssl != null : !((Object)this$ssl).equals(other$ssl)) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        AuthenticationMethod this$authentication = this.getAuthentication();
        AuthenticationMethod other$authentication = other.getAuthentication();
        return !(this$authentication == null ? other$authentication != null : !((Object)((Object)this$authentication)).equals((Object)other$authentication));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VaultProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        Discovery $discovery = this.getDiscovery();
        result = result * 59 + ($discovery == null ? 43 : ((Object)$discovery).hashCode());
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + (this.isFailFast() ? 79 : 97);
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        AppIdProperties $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
        AppRoleProperties $appRole = this.getAppRole();
        result = result * 59 + ($appRole == null ? 43 : ((Object)$appRole).hashCode());
        AwsEc2Properties $awsEc2 = this.getAwsEc2();
        result = result * 59 + ($awsEc2 == null ? 43 : ((Object)$awsEc2).hashCode());
        AwsIamProperties $awsIam = this.getAwsIam();
        result = result * 59 + ($awsIam == null ? 43 : ((Object)$awsIam).hashCode());
        AzureMsiProperties $azureMsi = this.getAzureMsi();
        result = result * 59 + ($azureMsi == null ? 43 : ((Object)$azureMsi).hashCode());
        GcpGceProperties $gcpGce = this.getGcpGce();
        result = result * 59 + ($gcpGce == null ? 43 : ((Object)$gcpGce).hashCode());
        GcpIamProperties $gcpIam = this.getGcpIam();
        result = result * 59 + ($gcpIam == null ? 43 : ((Object)$gcpIam).hashCode());
        KubernetesProperties $kubernetes = this.getKubernetes();
        result = result * 59 + ($kubernetes == null ? 43 : ((Object)$kubernetes).hashCode());
        Ssl $ssl = this.getSsl();
        result = result * 59 + ($ssl == null ? 43 : ((Object)$ssl).hashCode());
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        AuthenticationMethod $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : ((Object)((Object)$authentication)).hashCode());
        return result;
    }

    public String toString() {
        return "VaultProperties(enabled=" + this.isEnabled() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", scheme=" + this.getScheme() + ", uri=" + this.getUri() + ", discovery=" + this.getDiscovery() + ", connectionTimeout=" + this.getConnectionTimeout() + ", readTimeout=" + this.getReadTimeout() + ", failFast=" + this.isFailFast() + ", token=" + this.getToken() + ", appId=" + this.getAppId() + ", appRole=" + this.getAppRole() + ", awsEc2=" + this.getAwsEc2() + ", awsIam=" + this.getAwsIam() + ", azureMsi=" + this.getAzureMsi() + ", gcpGce=" + this.getGcpGce() + ", gcpIam=" + this.getGcpIam() + ", kubernetes=" + this.getKubernetes() + ", ssl=" + this.getSsl() + ", config=" + this.getConfig() + ", applicationName=" + this.getApplicationName() + ", authentication=" + (Object)((Object)this.getAuthentication()) + ")";
    }

    public static enum AuthenticationMethod {
        TOKEN,
        APPID,
        APPROLE,
        AWS_EC2,
        AWS_IAM,
        AZURE_MSI,
        CERT,
        CUBBYHOLE,
        GCP_GCE,
        GCP_IAM,
        KUBERNETES;

    }

    public static class Lifecycle {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Lifecycle)) {
                return false;
            }
            Lifecycle other = (Lifecycle)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isEnabled() == other.isEnabled();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Lifecycle;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "VaultProperties.Lifecycle(enabled=" + this.isEnabled() + ")";
        }
    }

    public static class Config {
        private int order = 0;
        private Lifecycle lifecycle = new Lifecycle();

        public int getOrder() {
            return this.order;
        }

        public Lifecycle getLifecycle() {
            return this.lifecycle;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public void setLifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOrder() != other.getOrder()) {
                return false;
            }
            Lifecycle this$lifecycle = this.getLifecycle();
            Lifecycle other$lifecycle = other.getLifecycle();
            return !(this$lifecycle == null ? other$lifecycle != null : !((Object)this$lifecycle).equals(other$lifecycle));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOrder();
            Lifecycle $lifecycle = this.getLifecycle();
            result = result * 59 + ($lifecycle == null ? 43 : ((Object)$lifecycle).hashCode());
            return result;
        }

        public String toString() {
            return "VaultProperties.Config(order=" + this.getOrder() + ", lifecycle=" + this.getLifecycle() + ")";
        }
    }

    @Validated
    public static class Ssl {
        private Resource keyStore;
        private String keyStorePassword;
        private Resource trustStore;
        private String trustStorePassword;
        @NotEmpty
        private String certAuthPath = "cert";

        public Resource getKeyStore() {
            return this.keyStore;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public Resource getTrustStore() {
            return this.trustStore;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public String getCertAuthPath() {
            return this.certAuthPath;
        }

        public void setKeyStore(Resource keyStore) {
            this.keyStore = keyStore;
        }

        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public void setTrustStore(Resource trustStore) {
            this.trustStore = trustStore;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        public void setCertAuthPath(String certAuthPath) {
            this.certAuthPath = certAuthPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ssl)) {
                return false;
            }
            Ssl other = (Ssl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Resource this$keyStore = this.getKeyStore();
            Resource other$keyStore = other.getKeyStore();
            if (this$keyStore == null ? other$keyStore != null : !this$keyStore.equals(other$keyStore)) {
                return false;
            }
            String this$keyStorePassword = this.getKeyStorePassword();
            String other$keyStorePassword = other.getKeyStorePassword();
            if (this$keyStorePassword == null ? other$keyStorePassword != null : !this$keyStorePassword.equals(other$keyStorePassword)) {
                return false;
            }
            Resource this$trustStore = this.getTrustStore();
            Resource other$trustStore = other.getTrustStore();
            if (this$trustStore == null ? other$trustStore != null : !this$trustStore.equals(other$trustStore)) {
                return false;
            }
            String this$trustStorePassword = this.getTrustStorePassword();
            String other$trustStorePassword = other.getTrustStorePassword();
            if (this$trustStorePassword == null ? other$trustStorePassword != null : !this$trustStorePassword.equals(other$trustStorePassword)) {
                return false;
            }
            String this$certAuthPath = this.getCertAuthPath();
            String other$certAuthPath = other.getCertAuthPath();
            return !(this$certAuthPath == null ? other$certAuthPath != null : !this$certAuthPath.equals(other$certAuthPath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Ssl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Resource $keyStore = this.getKeyStore();
            result = result * 59 + ($keyStore == null ? 43 : $keyStore.hashCode());
            String $keyStorePassword = this.getKeyStorePassword();
            result = result * 59 + ($keyStorePassword == null ? 43 : $keyStorePassword.hashCode());
            Resource $trustStore = this.getTrustStore();
            result = result * 59 + ($trustStore == null ? 43 : $trustStore.hashCode());
            String $trustStorePassword = this.getTrustStorePassword();
            result = result * 59 + ($trustStorePassword == null ? 43 : $trustStorePassword.hashCode());
            String $certAuthPath = this.getCertAuthPath();
            result = result * 59 + ($certAuthPath == null ? 43 : $certAuthPath.hashCode());
            return result;
        }

        public String toString() {
            return "VaultProperties.Ssl(keyStore=" + this.getKeyStore() + ", keyStorePassword=" + this.getKeyStorePassword() + ", trustStore=" + this.getTrustStore() + ", trustStorePassword=" + this.getTrustStorePassword() + ", certAuthPath=" + this.getCertAuthPath() + ")";
        }
    }

    public static class KubernetesProperties {
        @NotEmpty
        private String kubernetesPath = "kubernetes";
        private String role = "";
        @NotEmpty
        private String serviceAccountTokenFile = "/var/run/secrets/kubernetes.io/serviceaccount/token";

        public String getKubernetesPath() {
            return this.kubernetesPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getServiceAccountTokenFile() {
            return this.serviceAccountTokenFile;
        }

        public void setKubernetesPath(String kubernetesPath) {
            this.kubernetesPath = kubernetesPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setServiceAccountTokenFile(String serviceAccountTokenFile) {
            this.serviceAccountTokenFile = serviceAccountTokenFile;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KubernetesProperties)) {
                return false;
            }
            KubernetesProperties other = (KubernetesProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$kubernetesPath = this.getKubernetesPath();
            String other$kubernetesPath = other.getKubernetesPath();
            if (this$kubernetesPath == null ? other$kubernetesPath != null : !this$kubernetesPath.equals(other$kubernetesPath)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$serviceAccountTokenFile = this.getServiceAccountTokenFile();
            String other$serviceAccountTokenFile = other.getServiceAccountTokenFile();
            return !(this$serviceAccountTokenFile == null ? other$serviceAccountTokenFile != null : !this$serviceAccountTokenFile.equals(other$serviceAccountTokenFile));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KubernetesProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $kubernetesPath = this.getKubernetesPath();
            result = result * 59 + ($kubernetesPath == null ? 43 : $kubernetesPath.hashCode());
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $serviceAccountTokenFile = this.getServiceAccountTokenFile();
            result = result * 59 + ($serviceAccountTokenFile == null ? 43 : $serviceAccountTokenFile.hashCode());
            return result;
        }

        public String toString() {
            return "VaultProperties.KubernetesProperties(kubernetesPath=" + this.getKubernetesPath() + ", role=" + this.getRole() + ", serviceAccountTokenFile=" + this.getServiceAccountTokenFile() + ")";
        }
    }

    public static class GcpCredentials {
        private Resource location;
        private String encodedKey;

        public Resource getLocation() {
            return this.location;
        }

        public String getEncodedKey() {
            return this.encodedKey;
        }

        public void setLocation(Resource location) {
            this.location = location;
        }

        public void setEncodedKey(String encodedKey) {
            this.encodedKey = encodedKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GcpCredentials)) {
                return false;
            }
            GcpCredentials other = (GcpCredentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Resource this$location = this.getLocation();
            Resource other$location = other.getLocation();
            if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
                return false;
            }
            String this$encodedKey = this.getEncodedKey();
            String other$encodedKey = other.getEncodedKey();
            return !(this$encodedKey == null ? other$encodedKey != null : !this$encodedKey.equals(other$encodedKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GcpCredentials;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Resource $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : $location.hashCode());
            String $encodedKey = this.getEncodedKey();
            result = result * 59 + ($encodedKey == null ? 43 : $encodedKey.hashCode());
            return result;
        }

        public String toString() {
            return "VaultProperties.GcpCredentials(location=" + this.getLocation() + ", encodedKey=" + this.getEncodedKey() + ")";
        }
    }

    public static class GcpIamProperties {
        @NotEmpty
        private String gcpPath = "gcp";
        private String role = "";
        private String projectId = "";
        private String serviceAccountId = "";
        private Duration jwtValidity = Duration.ofMinutes(15L);
        private final GcpCredentials credentials = new GcpCredentials();

        public String getGcpPath() {
            return this.gcpPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getServiceAccountId() {
            return this.serviceAccountId;
        }

        public Duration getJwtValidity() {
            return this.jwtValidity;
        }

        public GcpCredentials getCredentials() {
            return this.credentials;
        }

        public void setGcpPath(String gcpPath) {
            this.gcpPath = gcpPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public void setServiceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
        }

        public void setJwtValidity(Duration jwtValidity) {
            this.jwtValidity = jwtValidity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GcpIamProperties)) {
                return false;
            }
            GcpIamProperties other = (GcpIamProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$gcpPath = this.getGcpPath();
            String other$gcpPath = other.getGcpPath();
            if (this$gcpPath == null ? other$gcpPath != null : !this$gcpPath.equals(other$gcpPath)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$projectId = this.getProjectId();
            String other$projectId = other.getProjectId();
            if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
                return false;
            }
            String this$serviceAccountId = this.getServiceAccountId();
            String other$serviceAccountId = other.getServiceAccountId();
            if (this$serviceAccountId == null ? other$serviceAccountId != null : !this$serviceAccountId.equals(other$serviceAccountId)) {
                return false;
            }
            Duration this$jwtValidity = this.getJwtValidity();
            Duration other$jwtValidity = other.getJwtValidity();
            if (this$jwtValidity == null ? other$jwtValidity != null : !((Object)this$jwtValidity).equals(other$jwtValidity)) {
                return false;
            }
            GcpCredentials this$credentials = this.getCredentials();
            GcpCredentials other$credentials = other.getCredentials();
            return !(this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GcpIamProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $gcpPath = this.getGcpPath();
            result = result * 59 + ($gcpPath == null ? 43 : $gcpPath.hashCode());
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $projectId = this.getProjectId();
            result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
            String $serviceAccountId = this.getServiceAccountId();
            result = result * 59 + ($serviceAccountId == null ? 43 : $serviceAccountId.hashCode());
            Duration $jwtValidity = this.getJwtValidity();
            result = result * 59 + ($jwtValidity == null ? 43 : ((Object)$jwtValidity).hashCode());
            GcpCredentials $credentials = this.getCredentials();
            result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
            return result;
        }

        public String toString() {
            return "VaultProperties.GcpIamProperties(gcpPath=" + this.getGcpPath() + ", role=" + this.getRole() + ", projectId=" + this.getProjectId() + ", serviceAccountId=" + this.getServiceAccountId() + ", jwtValidity=" + this.getJwtValidity() + ", credentials=" + this.getCredentials() + ")";
        }
    }

    public static class GcpGceProperties {
        @NotEmpty
        private String gcpPath = "gcp";
        private String role = "";
        private String serviceAccount = "";

        public String getGcpPath() {
            return this.gcpPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getServiceAccount() {
            return this.serviceAccount;
        }

        public void setGcpPath(String gcpPath) {
            this.gcpPath = gcpPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setServiceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GcpGceProperties)) {
                return false;
            }
            GcpGceProperties other = (GcpGceProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$gcpPath = this.getGcpPath();
            String other$gcpPath = other.getGcpPath();
            if (this$gcpPath == null ? other$gcpPath != null : !this$gcpPath.equals(other$gcpPath)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$serviceAccount = this.getServiceAccount();
            String other$serviceAccount = other.getServiceAccount();
            return !(this$serviceAccount == null ? other$serviceAccount != null : !this$serviceAccount.equals(other$serviceAccount));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GcpGceProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $gcpPath = this.getGcpPath();
            result = result * 59 + ($gcpPath == null ? 43 : $gcpPath.hashCode());
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $serviceAccount = this.getServiceAccount();
            result = result * 59 + ($serviceAccount == null ? 43 : $serviceAccount.hashCode());
            return result;
        }

        public String toString() {
            return "VaultProperties.GcpGceProperties(gcpPath=" + this.getGcpPath() + ", role=" + this.getRole() + ", serviceAccount=" + this.getServiceAccount() + ")";
        }
    }

    public static class AzureMsiProperties {
        @NotEmpty
        private String azurePath = "azure";
        private String role = "";

        public String getAzurePath() {
            return this.azurePath;
        }

        public String getRole() {
            return this.role;
        }

        public void setAzurePath(String azurePath) {
            this.azurePath = azurePath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AzureMsiProperties)) {
                return false;
            }
            AzureMsiProperties other = (AzureMsiProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$azurePath = this.getAzurePath();
            String other$azurePath = other.getAzurePath();
            if (this$azurePath == null ? other$azurePath != null : !this$azurePath.equals(other$azurePath)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            return !(this$role == null ? other$role != null : !this$role.equals(other$role));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AzureMsiProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $azurePath = this.getAzurePath();
            result = result * 59 + ($azurePath == null ? 43 : $azurePath.hashCode());
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            return result;
        }

        public String toString() {
            return "VaultProperties.AzureMsiProperties(azurePath=" + this.getAzurePath() + ", role=" + this.getRole() + ")";
        }
    }

    public static class AwsIamProperties {
        @NotEmpty
        private String awsPath = "aws";
        private String role = "";
        private String serverName;

        public String getAwsPath() {
            return this.awsPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setAwsPath(String awsPath) {
            this.awsPath = awsPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AwsIamProperties)) {
                return false;
            }
            AwsIamProperties other = (AwsIamProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$awsPath = this.getAwsPath();
            String other$awsPath = other.getAwsPath();
            if (this$awsPath == null ? other$awsPath != null : !this$awsPath.equals(other$awsPath)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$serverName = this.getServerName();
            String other$serverName = other.getServerName();
            return !(this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AwsIamProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $awsPath = this.getAwsPath();
            result = result * 59 + ($awsPath == null ? 43 : $awsPath.hashCode());
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $serverName = this.getServerName();
            result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
            return result;
        }

        public String toString() {
            return "VaultProperties.AwsIamProperties(awsPath=" + this.getAwsPath() + ", role=" + this.getRole() + ", serverName=" + this.getServerName() + ")";
        }
    }

    @Validated
    public static class AwsEc2Properties {
        @NotEmpty
        private String identityDocument = "http://169.254.169.254/latest/dynamic/instance-identity/pkcs7";
        @NotEmpty
        private String awsEc2Path = "aws-ec2";
        private String role = "";
        private String nonce;

        public String getIdentityDocument() {
            return this.identityDocument;
        }

        public String getAwsEc2Path() {
            return this.awsEc2Path;
        }

        public String getRole() {
            return this.role;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setIdentityDocument(String identityDocument) {
            this.identityDocument = identityDocument;
        }

        public void setAwsEc2Path(String awsEc2Path) {
            this.awsEc2Path = awsEc2Path;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AwsEc2Properties)) {
                return false;
            }
            AwsEc2Properties other = (AwsEc2Properties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$identityDocument = this.getIdentityDocument();
            String other$identityDocument = other.getIdentityDocument();
            if (this$identityDocument == null ? other$identityDocument != null : !this$identityDocument.equals(other$identityDocument)) {
                return false;
            }
            String this$awsEc2Path = this.getAwsEc2Path();
            String other$awsEc2Path = other.getAwsEc2Path();
            if (this$awsEc2Path == null ? other$awsEc2Path != null : !this$awsEc2Path.equals(other$awsEc2Path)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$nonce = this.getNonce();
            String other$nonce = other.getNonce();
            return !(this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AwsEc2Properties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $identityDocument = this.getIdentityDocument();
            result = result * 59 + ($identityDocument == null ? 43 : $identityDocument.hashCode());
            String $awsEc2Path = this.getAwsEc2Path();
            result = result * 59 + ($awsEc2Path == null ? 43 : $awsEc2Path.hashCode());
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $nonce = this.getNonce();
            result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
            return result;
        }

        public String toString() {
            return "VaultProperties.AwsEc2Properties(identityDocument=" + this.getIdentityDocument() + ", awsEc2Path=" + this.getAwsEc2Path() + ", role=" + this.getRole() + ", nonce=" + this.getNonce() + ")";
        }
    }

    @Validated
    public static class AppRoleProperties {
        private String appRolePath = "approle";
        private String role = "";
        private String roleId = null;
        private String secretId = null;

        public String getAppRolePath() {
            return this.appRolePath;
        }

        public String getRole() {
            return this.role;
        }

        public String getRoleId() {
            return this.roleId;
        }

        public String getSecretId() {
            return this.secretId;
        }

        public void setAppRolePath(String appRolePath) {
            this.appRolePath = appRolePath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppRoleProperties)) {
                return false;
            }
            AppRoleProperties other = (AppRoleProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$appRolePath = this.getAppRolePath();
            String other$appRolePath = other.getAppRolePath();
            if (this$appRolePath == null ? other$appRolePath != null : !this$appRolePath.equals(other$appRolePath)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$roleId = this.getRoleId();
            String other$roleId = other.getRoleId();
            if (this$roleId == null ? other$roleId != null : !this$roleId.equals(other$roleId)) {
                return false;
            }
            String this$secretId = this.getSecretId();
            String other$secretId = other.getSecretId();
            return !(this$secretId == null ? other$secretId != null : !this$secretId.equals(other$secretId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AppRoleProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $appRolePath = this.getAppRolePath();
            result = result * 59 + ($appRolePath == null ? 43 : $appRolePath.hashCode());
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $roleId = this.getRoleId();
            result = result * 59 + ($roleId == null ? 43 : $roleId.hashCode());
            String $secretId = this.getSecretId();
            result = result * 59 + ($secretId == null ? 43 : $secretId.hashCode());
            return result;
        }

        public String toString() {
            return "VaultProperties.AppRoleProperties(appRolePath=" + this.getAppRolePath() + ", role=" + this.getRole() + ", roleId=" + this.getRoleId() + ", secretId=" + this.getSecretId() + ")";
        }
    }

    @Validated
    public static class AppIdProperties {
        public static final String MAC_ADDRESS = "MAC_ADDRESS";
        public static final String IP_ADDRESS = "IP_ADDRESS";
        private String appIdPath = "app-id";
        private String networkInterface = null;
        @NotEmpty
        private String userId = "MAC_ADDRESS";

        public String getAppIdPath() {
            return this.appIdPath;
        }

        public String getNetworkInterface() {
            return this.networkInterface;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setAppIdPath(String appIdPath) {
            this.appIdPath = appIdPath;
        }

        public void setNetworkInterface(String networkInterface) {
            this.networkInterface = networkInterface;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppIdProperties)) {
                return false;
            }
            AppIdProperties other = (AppIdProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$appIdPath = this.getAppIdPath();
            String other$appIdPath = other.getAppIdPath();
            if (this$appIdPath == null ? other$appIdPath != null : !this$appIdPath.equals(other$appIdPath)) {
                return false;
            }
            String this$networkInterface = this.getNetworkInterface();
            String other$networkInterface = other.getNetworkInterface();
            if (this$networkInterface == null ? other$networkInterface != null : !this$networkInterface.equals(other$networkInterface)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AppIdProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $appIdPath = this.getAppIdPath();
            result = result * 59 + ($appIdPath == null ? 43 : $appIdPath.hashCode());
            String $networkInterface = this.getNetworkInterface();
            result = result * 59 + ($networkInterface == null ? 43 : $networkInterface.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            return result;
        }

        public String toString() {
            return "VaultProperties.AppIdProperties(appIdPath=" + this.getAppIdPath() + ", networkInterface=" + this.getNetworkInterface() + ", userId=" + this.getUserId() + ")";
        }
    }

    public static class Discovery {
        public static final String DEFAULT_VAULT = "vault";
        private boolean enabled;
        private String serviceId = "vault";

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Discovery)) {
                return false;
            }
            Discovery other = (Discovery)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$serviceId = this.getServiceId();
            String other$serviceId = other.getServiceId();
            return !(this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Discovery;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $serviceId = this.getServiceId();
            result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
            return result;
        }

        public String toString() {
            return "VaultProperties.Discovery(enabled=" + this.isEnabled() + ", serviceId=" + this.getServiceId() + ")";
        }
    }
}

