/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.listener.SkipListener;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.cloud.task.batch.listener.support.TaskEventProperties;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class EventEmittingSkipListener
implements SkipListener,
Ordered {
    private static final Log logger = LogFactory.getLog(EventEmittingSkipListener.class);
    private final MessagePublisher<Object> messagePublisher;
    private int order = Integer.MAX_VALUE;
    private TaskEventProperties properties;

    public EventEmittingSkipListener(MessagePublisher messagePublisher, TaskEventProperties properties) {
        Assert.notNull((Object)messagePublisher, (String)"messagePublisher is required");
        Assert.notNull((Object)properties, (String)"properties is required");
        this.messagePublisher = messagePublisher;
        this.properties = properties;
    }

    public EventEmittingSkipListener(MessagePublisher messagePublisher, int order, TaskEventProperties properties) {
        this(messagePublisher, properties);
        this.order = order;
    }

    public void onSkipInRead(Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing onSkipInRead: " + t.getMessage()), t);
        }
        this.messagePublisher.publishWithThrowableHeader(this.properties.getSkipEventBindingName(), "Skipped when reading.", t.getMessage());
    }

    public void onSkipInWrite(Object item, Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing onSkipInWrite: " + t.getMessage()), t);
        }
        this.messagePublisher.publishWithThrowableHeader(this.properties.getSkipEventBindingName(), item, t.getMessage());
    }

    public void onSkipInProcess(Object item, Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing onSkipInProcess: " + t.getMessage()), t);
        }
        this.messagePublisher.publishWithThrowableHeader(this.properties.getSkipEventBindingName(), item, t.getMessage());
    }

    public int getOrder() {
        return this.order;
    }
}

