/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.springframework.batch.core.job.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListener;
import org.springframework.cloud.task.batch.listener.support.JobExecutionEvent;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.cloud.task.batch.listener.support.TaskEventProperties;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class EventEmittingJobExecutionListener
implements JobExecutionListener,
Ordered {
    private int order = Integer.MAX_VALUE;
    private final MessagePublisher<JobExecutionEvent> messagePublisher;
    private TaskEventProperties properties;

    public EventEmittingJobExecutionListener(MessagePublisher messagePublisher, TaskEventProperties properties) {
        Assert.notNull((Object)messagePublisher, (String)"messagePublisher is required");
        Assert.notNull((Object)properties, (String)"properties is required");
        this.messagePublisher = messagePublisher;
        this.properties = properties;
    }

    public EventEmittingJobExecutionListener(MessagePublisher messagePublisher, int order, TaskEventProperties properties) {
        this(messagePublisher, properties);
        this.order = order;
    }

    public void beforeJob(JobExecution jobExecution) {
        this.messagePublisher.publish(this.properties.getJobExecutionEventBindingName(), new JobExecutionEvent(jobExecution));
    }

    public void afterJob(JobExecution jobExecution) {
        this.messagePublisher.publish(this.properties.getJobExecutionEventBindingName(), new JobExecutionEvent(jobExecution));
    }

    public int getOrder() {
        return this.order;
    }
}

