/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.job.Job;
import org.springframework.batch.core.job.JobExecution;
import org.springframework.batch.core.job.JobExecutionException;
import org.springframework.batch.core.job.JobInstance;
import org.springframework.batch.core.job.parameters.InvalidJobParametersException;
import org.springframework.batch.core.job.parameters.JobParameter;
import org.springframework.batch.core.job.parameters.JobParameters;
import org.springframework.batch.core.job.parameters.JobParametersIncrementer;
import org.springframework.batch.core.launch.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.launch.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.JobRestartException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.infrastructure.repeat.RepeatStatus;
import org.springframework.batch.infrastructure.repeat.support.RepeatTemplate;
import org.springframework.boot.batch.autoconfigure.JobExecutionEvent;
import org.springframework.boot.batch.autoconfigure.JobLauncherApplicationRunner;
import org.springframework.cloud.task.batch.configuration.TaskBatchProperties;
import org.springframework.cloud.task.listener.TaskException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TaskJobLauncherApplicationRunner
extends JobLauncherApplicationRunner {
    private static final Log logger = LogFactory.getLog(TaskJobLauncherApplicationRunner.class);
    private final JobOperator taskJobOperator;
    private final JobRepository taskJobRepository;
    private final List<JobExecution> jobExecutionList = new ArrayList<JobExecution>();
    private ApplicationEventPublisher taskApplicationEventPublisher;
    private final TaskBatchProperties taskBatchProperties;

    public TaskJobLauncherApplicationRunner(JobOperator jobOperator, JobRepository jobRepository, TaskBatchProperties taskBatchProperties) {
        super(jobOperator);
        this.taskJobOperator = jobOperator;
        this.taskJobRepository = jobRepository;
        this.taskBatchProperties = taskBatchProperties;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        super.setApplicationEventPublisher(publisher);
        this.taskApplicationEventPublisher = publisher;
    }

    public void run(String ... args) throws JobExecutionException {
        logger.info((Object)("Running default command line with: " + String.valueOf(Arrays.asList(args))));
        Properties properties = StringUtils.splitArrayElementsIntoProperties((String[])args, (String)"=");
        if (properties == null) {
            properties = new Properties();
        }
        this.launchJobFromProperties(properties);
        this.monitorJobExecutions();
    }

    protected void execute(Job job, JobParameters jobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, InvalidJobParametersException {
        boolean jobInstanceExists;
        String jobName = job.getName();
        JobParameters parameters = jobParameters;
        boolean bl = jobInstanceExists = this.taskJobRepository.getJobInstance(job.getName(), jobParameters) != null;
        if (jobInstanceExists) {
            JobExecution lastJobExecution = this.taskJobRepository.getLastJobExecution(jobName, jobParameters);
            if (lastJobExecution != null && this.isStoppedOrFailed(lastJobExecution) && job.isRestartable()) {
                JobParameters previousParameters = lastJobExecution.getJobParameters();
                JobParameters previousIdentifyingParameters = this.removeNonIdentifying(previousParameters);
                parameters = this.merge(previousIdentifyingParameters, jobParameters);
            }
        } else {
            JobParametersIncrementer incrementer = job.getJobParametersIncrementer();
            if (incrementer != null) {
                JobParameters nextParameters = this.getNextJobParameters(job, new HashSet(jobParameters.parameters()), this.taskJobRepository);
                parameters = this.merge(nextParameters, jobParameters);
            }
        }
        JobExecution execution = this.taskJobOperator.start(job, parameters);
        if (this.taskApplicationEventPublisher != null) {
            this.taskApplicationEventPublisher.publishEvent((ApplicationEvent)new JobExecutionEvent(execution));
        }
        this.jobExecutionList.add(execution);
        if (execution.getStatus().equals((Object)BatchStatus.FAILED)) {
            this.throwJobFailedException(Collections.singletonList(execution));
        }
    }

    private void monitorJobExecutions() {
        RepeatTemplate template = new RepeatTemplate();
        template.iterate(context -> {
            ArrayList<JobExecution> failedJobExecutions = new ArrayList<JobExecution>();
            for (JobExecution jobExecution : this.jobExecutionList) {
                BatchStatus batchStatus = this.getCurrentBatchStatus(jobExecution);
                if (batchStatus.isRunning()) {
                    Thread.sleep(this.taskBatchProperties.getFailOnJobFailurePollInterval());
                    return RepeatStatus.CONTINUABLE;
                }
                if (!batchStatus.equals((Object)BatchStatus.FAILED)) continue;
                failedJobExecutions.add(jobExecution);
            }
            if (failedJobExecutions.size() > 0) {
                this.throwJobFailedException(failedJobExecutions);
            }
            return RepeatStatus.FINISHED;
        });
    }

    private BatchStatus getCurrentBatchStatus(JobExecution jobExecution) {
        if (jobExecution.getStatus().isRunning()) {
            return this.taskJobRepository.getJobExecution(jobExecution.getId()).getStatus();
        }
        return jobExecution.getStatus();
    }

    private void throwJobFailedException(List<JobExecution> failedJobExecutions) {
        StringBuilder message = new StringBuilder("The following Jobs have failed: \n");
        for (JobExecution failedJobExecution : failedJobExecutions) {
            message.append(String.format("Job %s failed during execution for job instance id %s with jobExecutionId of %s \n", failedJobExecution.getJobInstance().getJobName(), failedJobExecution.getId(), failedJobExecution.getId()));
        }
        logger.error((Object)message);
        throw new TaskException(message.toString());
    }

    private JobParameters removeNonIdentifying(JobParameters parameters) {
        Set parameterMap = parameters.parameters();
        HashSet<JobParameter> copy = new HashSet<JobParameter>();
        for (JobParameter parameter : parameterMap) {
            if (!parameter.identifying()) continue;
            copy.add(parameter);
        }
        return new JobParameters(copy);
    }

    private boolean isStoppedOrFailed(JobExecution execution) {
        BatchStatus status = execution.getStatus();
        return status == BatchStatus.STOPPED || status == BatchStatus.FAILED;
    }

    private JobParameters merge(JobParameters parameters, JobParameters additionals) {
        HashMap<String, JobParameter> merged = new HashMap<String, JobParameter>();
        for (JobParameter param : parameters.parameters()) {
            merged.put(param.name(), param);
        }
        for (JobParameter param : additionals.parameters()) {
            merged.put(param.name(), param);
        }
        return new JobParameters(new HashSet(merged.values()));
    }

    public JobParameters getNextJobParameters(Job job, Set<JobParameter<?>> parameterMap, JobRepository taskJobRepository) {
        JobExecution previousExecution;
        Assert.notNull((Object)job, (String)"Job must not be null");
        Assert.notNull((Object)job.getJobParametersIncrementer(), (String)("No job parameters incrementer found for job=" + job.getName()));
        String name = job.getName();
        JobInstance lastInstance = taskJobRepository.getLastJobInstance(name);
        JobParametersIncrementer incrementer = job.getJobParametersIncrementer();
        JobParameters nextParameters = lastInstance == null ? incrementer.getNext(new JobParameters()) : ((previousExecution = taskJobRepository.getLastJobExecution(lastInstance)) == null ? incrementer.getNext(new JobParameters()) : incrementer.getNext(previousExecution.getJobParameters()));
        HashSet nextParametersMap = new HashSet(nextParameters.parameters());
        nextParametersMap.addAll(parameterMap);
        parameterMap = nextParametersMap;
        return new JobParameters(parameterMap);
    }
}

