/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.configuration;

import org.springframework.batch.core.job.Job;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.batch.configuration.TaskBatchExecutionListenerBeanPostProcessor;
import org.springframework.cloud.task.batch.configuration.TaskBatchExecutionListenerFactoryBean;
import org.springframework.cloud.task.configuration.TaskConfigurer;
import org.springframework.cloud.task.configuration.TaskProperties;
import org.springframework.cloud.task.listener.TaskLifecycleListener;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnBean(value={Job.class, TaskLifecycleListener.class})
@ConditionalOnProperty(name={"spring.cloud.task.batch.listener.enable", "spring.cloud.task.batch.listener.enabled"}, havingValue="true", matchIfMissing=true)
public class TaskBatchAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public static TaskBatchExecutionListenerBeanPostProcessor batchTaskExecutionListenerBeanPostProcessor() {
        return new TaskBatchExecutionListenerBeanPostProcessor();
    }

    @AutoConfiguration
    @ConditionalOnMissingBean(name={"taskBatchExecutionListener"})
    @EnableConfigurationProperties(value={TaskProperties.class})
    public static class TaskBatchExecutionListenerAutoconfiguration {
        @Autowired
        private ApplicationContext context;
        @Autowired
        private TaskProperties taskProperties;

        @Bean
        public TaskBatchExecutionListenerFactoryBean taskBatchExecutionListener(TaskExplorer taskExplorer) {
            TaskConfigurer taskConfigurer = null;
            if (!this.context.getBeansOfType(TaskConfigurer.class).isEmpty()) {
                taskConfigurer = (TaskConfigurer)this.context.getBean(TaskConfigurer.class);
            }
            if (taskConfigurer != null && taskConfigurer.getTaskDataSource() != null) {
                return new TaskBatchExecutionListenerFactoryBean(taskConfigurer.getTaskDataSource(), taskExplorer, this.taskProperties.getTablePrefix());
            }
            return new TaskBatchExecutionListenerFactoryBean(null, taskExplorer, this.taskProperties.getTablePrefix());
        }
    }
}

