/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.partition;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.cloud.task.batch.partition.CommandLineArgsProvider;
import org.springframework.cloud.task.listener.TaskExecutionListener;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.util.Assert;

public class SimpleCommandLineArgsProvider
implements CommandLineArgsProvider,
TaskExecutionListener {
    private TaskExecution taskExecution;
    private List<String> appendedArgs;

    public SimpleCommandLineArgsProvider() {
    }

    public SimpleCommandLineArgsProvider(TaskExecution taskExecution) {
        Assert.notNull((Object)taskExecution, (String)"A taskExecution is required");
        this.taskExecution = taskExecution;
    }

    public void onTaskStartup(TaskExecution taskExecution) {
        this.taskExecution = taskExecution;
    }

    public void setAppendedArgs(List<String> appendedArgs) {
        this.appendedArgs = appendedArgs;
    }

    @Override
    public List<String> getCommandLineArgs(ExecutionContext executionContext) {
        int listSize = this.taskExecution.getArguments().size() + (this.appendedArgs != null ? this.appendedArgs.size() : 0);
        ArrayList<String> args = new ArrayList<String>(listSize);
        args.addAll(this.taskExecution.getArguments());
        if (this.appendedArgs != null) {
            args.addAll(this.appendedArgs);
        }
        return args;
    }
}

