/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.endpoint;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.SanitizableData;
import org.springframework.boot.actuate.endpoint.Sanitizer;
import org.springframework.boot.actuate.endpoint.SanitizingFunction;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.BindingsLifecycleController;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

@Endpoint(id="bindings")
public class BindingsEndpoint {
    private final BindingsLifecycleController lifecycleController;
    private final Sanitizer sanitizer;
    private final ObjectMapper objectMapper;

    public BindingsEndpoint(BindingsLifecycleController lifecycleController) {
        this(lifecycleController, null, null);
    }

    public BindingsEndpoint(BindingsLifecycleController lifecycleController, @Nullable Iterable<SanitizingFunction> sanitizingFunctions, @Nullable ObjectMapper objectMapper) {
        this.lifecycleController = lifecycleController;
        this.sanitizer = CollectionUtils.isEmpty((Collection)((Collection)sanitizingFunctions)) ? null : new Sanitizer(sanitizingFunctions);
        this.objectMapper = objectMapper;
    }

    @WriteOperation
    public void changeState(@Selector String name, BindingsLifecycleController.State state) {
        this.lifecycleController.changeState(name, state);
    }

    @ReadOperation
    public List<Map<String, Object>> queryStates() {
        List<Map<String, Object>> bindings = this.lifecycleController.queryStates();
        if (this.sanitizer != null) {
            for (Map<String, Object> binding : bindings) {
                this.sanitizeSensitiveData(binding);
            }
        }
        return bindings;
    }

    @ReadOperation
    public List<Binding<?>> queryState(@Selector String name) {
        List<Binding<?>> bindings = this.lifecycleController.queryState(name);
        if (this.sanitizer != null) {
            List bindingsAsMap = (List)this.objectMapper.convertValue(bindings, List.class);
            for (Map binding : bindingsAsMap) {
                this.sanitizeSensitiveData(binding);
            }
            return (List)this.objectMapper.convertValue((Object)bindingsAsMap, List.class);
        }
        return bindings;
    }

    public void sanitizeSensitiveData(Map<String, Object> binding) {
        for (String key : binding.keySet()) {
            Object value = binding.get(key);
            if (value != null && Map.class.isAssignableFrom(value.getClass())) {
                this.sanitizeSensitiveData((Map)value);
                continue;
            }
            SanitizableData sanitizableData = new SanitizableData(null, key, value);
            Object sanitized = this.sanitizer.sanitize(sanitizableData, true);
            binding.put(key, sanitized);
        }
    }
}

