/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.endpoint.SanitizingFunction;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.BindingsLifecycleController;
import org.springframework.cloud.stream.endpoint.BindingsEndpoint;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(name={"org.springframework.boot.actuate.endpoint.annotation.Endpoint"})
@ConditionalOnBean(value={BindingService.class})
@AutoConfigureAfter(value={EndpointAutoConfiguration.class})
public class BindingsEndpointAutoConfiguration {
    @Bean
    @ConditionalOnAvailableEndpoint
    public BindingsEndpoint bindingsEndpoint(BindingsLifecycleController bindingsLifecycleController, ObjectProvider<SanitizingFunction> sanitizingFunctions) {
        return new BindingsEndpoint(bindingsLifecycleController, sanitizingFunctions.orderedStream().toList(), bindingsLifecycleController.getObjectMapper());
    }
}

