/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.integration.support.converter.DefaultDatatypeChannelMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;

@Configuration
@Role(value=2)
class ContentTypeConfiguration {
    ContentTypeConfiguration() {
    }

    @Bean(name={"integrationArgumentResolverMessageConverter"})
    public CompositeMessageConverter configurableCompositeMessageConverter(ObjectProvider<ObjectMapper> objectMapperObjectProvider, List<MessageConverter> customMessageConverters) {
        customMessageConverters = customMessageConverters.stream().filter(c -> !(c instanceof DefaultDatatypeChannelMessageConverter)).collect(Collectors.toList());
        CompositeMessageConverterFactory factory = new CompositeMessageConverterFactory(customMessageConverters, (ObjectMapper)objectMapperObjectProvider.getIfAvailable(ObjectMapper::new));
        return factory.getMessageConverterForAllRegistered();
    }
}

