/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.cloud.stream.annotation.Bindings;
import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.stream.binding.BindableProxyFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class BindingBeanDefinitionRegistryUtils {
    public static void registerInputBindingTargetBeanDefinition(String qualifierValue, String name, String bindingTargetInterfaceBeanName, String bindingTargetInterfaceMethodName, BeanDefinitionRegistry registry) {
        BindingBeanDefinitionRegistryUtils.registerBindingTargetBeanDefinition(Input.class, qualifierValue, name, bindingTargetInterfaceBeanName, bindingTargetInterfaceMethodName, registry);
    }

    public static void registerOutputBindingTargetBeanDefinition(String qualifierValue, String name, String bindingTargetInterfaceBeanName, String bindingTargetInterfaceMethodName, BeanDefinitionRegistry registry) {
        BindingBeanDefinitionRegistryUtils.registerBindingTargetBeanDefinition(Output.class, qualifierValue, name, bindingTargetInterfaceBeanName, bindingTargetInterfaceMethodName, registry);
    }

    private static void registerBindingTargetBeanDefinition(Class<? extends Annotation> qualifier, String qualifierValue, String name, String bindingTargetInterfaceBeanName, String bindingTargetInterfaceMethodName, BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(name)) {
            throw new BeanDefinitionStoreException(bindingTargetInterfaceBeanName, name, "bean definition with this name already exists - " + registry.getBeanDefinition(name));
        }
        RootBeanDefinition rootBeanDefinition = new RootBeanDefinition();
        rootBeanDefinition.setFactoryBeanName(bindingTargetInterfaceBeanName);
        rootBeanDefinition.setUniqueFactoryMethodName(bindingTargetInterfaceMethodName);
        rootBeanDefinition.addQualifier(new AutowireCandidateQualifier(qualifier, (Object)qualifierValue));
        registry.registerBeanDefinition(name, (BeanDefinition)rootBeanDefinition);
    }

    public static void registerBindingTargetBeanDefinitions(Class<?> type, String bindingTargetInterfaceBeanName, BeanDefinitionRegistry registry) {
        ReflectionUtils.doWithMethods(type, method -> {
            Output output;
            Input input = (Input)AnnotationUtils.findAnnotation((Method)method, Input.class);
            if (input != null) {
                String name = BindingBeanDefinitionRegistryUtils.getBindingTargetName(input, method);
                BindingBeanDefinitionRegistryUtils.registerInputBindingTargetBeanDefinition(input.value(), name, bindingTargetInterfaceBeanName, method.getName(), registry);
            }
            if ((output = (Output)AnnotationUtils.findAnnotation((Method)method, Output.class)) != null) {
                String name = BindingBeanDefinitionRegistryUtils.getBindingTargetName(output, method);
                BindingBeanDefinitionRegistryUtils.registerOutputBindingTargetBeanDefinition(output.value(), name, bindingTargetInterfaceBeanName, method.getName(), registry);
            }
        });
    }

    public static void registerBindingTargetsQualifiedBeanDefinitions(Class<?> parent, Class<?> type, BeanDefinitionRegistry registry) {
        if (type.isInterface()) {
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(BindableProxyFactory.class);
            rootBeanDefinition.addQualifier(new AutowireCandidateQualifier(Bindings.class, parent));
            rootBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue(type);
            registry.registerBeanDefinition(type.getName(), (BeanDefinition)rootBeanDefinition);
        } else {
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(type);
            rootBeanDefinition.addQualifier(new AutowireCandidateQualifier(Bindings.class, parent));
            registry.registerBeanDefinition(type.getName(), (BeanDefinition)rootBeanDefinition);
        }
    }

    public static String getBindingTargetName(Annotation annotation, Method method) {
        Map attrs = AnnotationUtils.getAnnotationAttributes((Annotation)annotation, (boolean)false);
        if (attrs.containsKey("value") && StringUtils.hasText((CharSequence)((CharSequence)attrs.get("value")))) {
            return (String)attrs.get("value");
        }
        return method.getName();
    }
}

