/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.micrometer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.step.StepCounter;
import io.micrometer.core.instrument.step.StepDistributionSummary;
import io.micrometer.core.instrument.step.StepFunctionCounter;
import io.micrometer.core.instrument.step.StepFunctionTimer;
import io.micrometer.core.instrument.step.StepTimer;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.micrometer.ApplicationMetrics;
import org.springframework.cloud.stream.micrometer.ApplicationMetricsProperties;
import org.springframework.cloud.stream.micrometer.MetersPublisherBinding;
import org.springframework.cloud.stream.micrometer.Metric;
import org.springframework.cloud.stream.micrometer.MetricsPublisherConfig;
import org.springframework.context.SmartLifecycle;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

class DefaultDestinationPublishingMeterRegistry
extends MeterRegistry
implements SmartLifecycle {
    private static final Log logger = LogFactory.getLog(DefaultDestinationPublishingMeterRegistry.class);
    private final MetricsPublisherConfig metricsPublisherConfig;
    private final Consumer<String> metricsConsumer;
    private final ApplicationMetricsProperties applicationProperties;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private ScheduledFuture<?> publisher;

    DefaultDestinationPublishingMeterRegistry(ApplicationMetricsProperties applicationProperties, MetersPublisherBinding publisherBinding, MetricsPublisherConfig metricsPublisherConfig, Clock clock) {
        super(clock);
        this.metricsPublisherConfig = metricsPublisherConfig;
        this.metricsConsumer = new MessageChannelPublisher(publisherBinding);
        this.applicationProperties = applicationProperties;
    }

    public void start() {
        this.start(Executors.defaultThreadFactory());
    }

    public void stop() {
        if (this.publisher != null) {
            this.publisher.cancel(false);
            this.publisher = null;
        }
    }

    public boolean isRunning() {
        return this.publisher != null;
    }

    public int getPhase() {
        return 0;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        return new DefaultGauge(id, obj, f);
    }

    protected Counter newCounter(Meter.Id id) {
        return new StepCounter(id, this.clock, this.metricsPublisherConfig.step().toMillis());
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        return new DefaultLongTaskTimer(id, this.clock);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    protected void publish() {
        ArrayList<Metric<Number>> aggregatedMeters = new ArrayList<Metric<Number>>();
        for (Meter meter : this.getMeters()) {
            if (meter instanceof Timer) {
                aggregatedMeters.add(this.toTimerMetric((Timer)meter));
                continue;
            }
            if (!(meter instanceof DistributionSummary)) continue;
            aggregatedMeters.add(this.toSummaryMetric((DistributionSummary)meter));
        }
        if (!aggregatedMeters.isEmpty()) {
            ApplicationMetrics metrics = new ApplicationMetrics(this.applicationProperties.getKey(), aggregatedMeters);
            metrics.setInterval(this.metricsPublisherConfig.step().toMillis());
            metrics.setProperties(this.applicationProperties.getExportProperties());
            try {
                String jsonString = this.objectMapper.writeValueAsString((Object)metrics);
                this.metricsConsumer.accept(jsonString);
            }
            catch (JsonProcessingException e) {
                logger.warn((Object)"Error producing JSON String representation metric data", (Throwable)e);
            }
        }
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return new StepTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit());
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        return new StepFunctionTimer(id, this.clock, this.metricsPublisherConfig.step().toMillis(), obj, countFunction, totalTimeFunction, totalTimeFunctionUnits, this.getBaseTimeUnit());
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> valueFunction) {
        return new StepFunctionCounter(id, this.clock, this.metricsPublisherConfig.step().toMillis(), obj, valueFunction);
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        return new StepDistributionSummary(id, this.clock, distributionStatisticConfig, scale);
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.metricsPublisherConfig.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    private void start(ThreadFactory threadFactory) {
        if (this.publisher != null) {
            this.stop();
        }
        this.publisher = Executors.newSingleThreadScheduledExecutor(threadFactory).scheduleAtFixedRate(this::publish, this.metricsPublisherConfig.step().toMillis(), this.metricsPublisherConfig.step().toMillis(), TimeUnit.MILLISECONDS);
    }

    private Metric<Number> toSummaryMetric(DistributionSummary summary) {
        return new Metric<Number>(summary.getId(), summary.takeSnapshot(false));
    }

    private Metric<Number> toTimerMetric(Timer timer) {
        return new Metric<Number>(timer.getId(), timer.takeSnapshot(false));
    }

    private static final class MessageChannelPublisher
    implements Consumer<String> {
        private final MetersPublisherBinding metersPublisherBinding;

        MessageChannelPublisher(MetersPublisherBinding metersPublisherBinding) {
            this.metersPublisherBinding = metersPublisherBinding;
        }

        @Override
        public void accept(String metricData) {
            logger.trace((Object)metricData);
            Message message = MessageBuilder.withPayload((Object)metricData).setHeader("STREAM_CLOUD_STREAM_VERSION", (Object)"2.x").build();
            this.metersPublisherBinding.applicationMetrics().send(message);
        }
    }
}

