/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import com.fasterxml.jackson.annotation.JsonInclude;
import javax.validation.constraints.Min;
import org.springframework.cloud.stream.binder.HeaderMode;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ConsumerProperties {
    private int concurrency = 1;
    private boolean partitioned;
    private int instanceCount = -1;
    private int instanceIndex = -1;
    private int maxAttempts = 3;
    private int backOffInitialInterval = 1000;
    private int backOffMaxInterval = 10000;
    private double backOffMultiplier = 2.0;
    private HeaderMode headerMode = HeaderMode.embeddedHeaders;

    @Min(value=1L, message="Concurrency should be greater than zero.")
    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public boolean isPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(boolean partitioned) {
        this.partitioned = partitioned;
    }

    @Min(value=1L, message="Instance count should be greater than zero.")
    public int getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(int instanceCount) {
        this.instanceCount = instanceCount;
    }

    @Min(value=0L, message="Instance index should be greater than or equal to 0")
    public int getInstanceIndex() {
        return this.instanceIndex;
    }

    public void setInstanceIndex(int instanceIndex) {
        this.instanceIndex = instanceIndex;
    }

    @Min(value=1L, message="Max attempts should be greater than zero.")
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    @Min(value=1L, message="Backoff initial interval should be greater than zero.")
    public int getBackOffInitialInterval() {
        return this.backOffInitialInterval;
    }

    public void setBackOffInitialInterval(int backOffInitialInterval) {
        this.backOffInitialInterval = backOffInitialInterval;
    }

    @Min(value=1L, message="Backoff max interval should be greater than zero.")
    public int getBackOffMaxInterval() {
        return this.backOffMaxInterval;
    }

    public void setBackOffMaxInterval(int backOffMaxInterval) {
        this.backOffMaxInterval = backOffMaxInterval;
    }

    @Min(value=1L, message="Backoff multiplier should be greater than zero.")
    public double getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(double backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public HeaderMode getHeaderMode() {
        return this.headerMode;
    }

    public void setHeaderMode(HeaderMode headerMode) {
        this.headerMode = headerMode;
    }
}

