/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.cloud.stream.binding.StreamListenerMessageHandler;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

final class DispatchingStreamListenerMessageHandler
extends AbstractReplyProducingMessageHandler {
    private final Collection<ConditionalStreamListenerHandler> handlerMethods;
    private final EvaluationContext evaluationContext;

    DispatchingStreamListenerMessageHandler(Collection<ConditionalStreamListenerHandler> handlerMethods, EvaluationContext evaluationContext) {
        Assert.notEmpty(handlerMethods, (String)"'handlerMethods' cannot be empty");
        Assert.notNull((Object)evaluationContext, (String)"'evaluationContext' cannot be empty");
        this.handlerMethods = handlerMethods;
        this.evaluationContext = evaluationContext;
    }

    protected boolean shouldCopyRequestHeaders() {
        return false;
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Collection<ConditionalStreamListenerHandler> matchingHandlers = this.findMatchingHandlers(requestMessage);
        if (matchingHandlers.size() == 0) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Cannot find a @StreamListener matching for message with id: " + requestMessage.getHeaders().getId()));
            }
            return null;
        }
        if (matchingHandlers.size() > 1) {
            for (ConditionalStreamListenerHandler matchingMethod : matchingHandlers) {
                matchingMethod.handleMessage(requestMessage);
            }
            return null;
        }
        ConditionalStreamListenerHandler singleMatchingHandler = matchingHandlers.iterator().next();
        singleMatchingHandler.handleMessage(requestMessage);
        return null;
    }

    private Collection<ConditionalStreamListenerHandler> findMatchingHandlers(Message<?> message) {
        ArrayList<ConditionalStreamListenerHandler> matchingMethods = new ArrayList<ConditionalStreamListenerHandler>();
        for (ConditionalStreamListenerHandler conditionalStreamListenerHandlerMethod : this.handlerMethods) {
            if (conditionalStreamListenerHandlerMethod.getCondition() == null) {
                matchingMethods.add(conditionalStreamListenerHandlerMethod);
                continue;
            }
            boolean conditionMetOnMessage = (Boolean)conditionalStreamListenerHandlerMethod.getCondition().getValue(this.evaluationContext, message, Boolean.class);
            if (!conditionMetOnMessage) continue;
            matchingMethods.add(conditionalStreamListenerHandlerMethod);
        }
        return matchingMethods;
    }

    static class ConditionalStreamListenerHandler
    implements MessageHandler {
        private Expression condition;
        private StreamListenerMessageHandler streamListenerMessageHandler;

        ConditionalStreamListenerHandler(Expression condition, StreamListenerMessageHandler streamListenerMessageHandler) {
            Assert.notNull((Object)((Object)streamListenerMessageHandler), (String)"the message handler cannot be null");
            Assert.isTrue((condition == null || streamListenerMessageHandler.isVoid() ? 1 : 0) != 0, (String)"cannot specify a condition and a return value at the same time");
            this.condition = condition;
            this.streamListenerMessageHandler = streamListenerMessageHandler;
        }

        public Expression getCondition() {
            return this.condition;
        }

        public boolean isVoid() {
            return this.streamListenerMessageHandler.isVoid();
        }

        public void handleMessage(Message<?> message) throws MessagingException {
            this.streamListenerMessageHandler.handleMessage(message);
        }
    }
}

