/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.aggregate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.boot.actuate.endpoint.MetricReaderPublicMetrics;
import org.springframework.boot.actuate.endpoint.MetricsEndpoint;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.stream.aggregate.AggregateApplication;
import org.springframework.cloud.stream.aggregate.NamespaceAwareSpringIntegrationMetricReader;
import org.springframework.cloud.stream.aggregate.SharedChannelRegistry;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.monitor.IntegrationMBeanExporter;
import org.springframework.util.StringUtils;

public class AggregateApplicationBuilder {
    private SourceConfigurer sourceConfigurer;
    private SinkConfigurer sinkConfigurer;
    private List<ProcessorConfigurer> processorConfigurers = new ArrayList<ProcessorConfigurer>();
    private AggregateApplicationBuilder applicationBuilder = this;
    private ConfigurableApplicationContext parentContext;
    private List<Object> parentSources = new ArrayList<Object>();
    private List<String> parentArgs = new ArrayList<String>();
    private boolean headless = true;
    private boolean webEnvironment = true;

    public AggregateApplicationBuilder(String ... args) {
        this(new Object[]{ParentConfiguration.class}, args);
    }

    public AggregateApplicationBuilder(Object source, String ... args) {
        this(new Object[]{source}, args);
    }

    public AggregateApplicationBuilder(Object[] sources, String[] args) {
        this.addParentSources(sources);
        this.parentArgs.addAll(Arrays.asList(args));
    }

    private void addParentSources(Object[] sources) {
        if (!this.parentSources.contains(ParentConfiguration.class)) {
            this.parentSources.add(ParentConfiguration.class);
        }
        this.parentSources.addAll(Arrays.asList(sources));
    }

    public AggregateApplicationBuilder parent(Object source, String ... args) {
        return this.parent(new Object[]{source}, args);
    }

    public AggregateApplicationBuilder parent(Object[] sources, String[] args) {
        this.addParentSources(sources);
        this.parentArgs.addAll(Arrays.asList(args));
        return this;
    }

    public AggregateApplicationBuilder web(boolean webEnvironment) {
        this.webEnvironment = webEnvironment;
        return this;
    }

    public AggregateApplicationBuilder headless(boolean headless) {
        this.headless = headless;
        return this;
    }

    public SourceConfigurer from(Class<?> app) {
        SourceConfigurer sourceConfigurer;
        this.sourceConfigurer = sourceConfigurer = new SourceConfigurer(app);
        return sourceConfigurer;
    }

    public ConfigurableApplicationContext run(String[] parentArgsFromRun) {
        this.parentArgs.addAll(Arrays.asList(parentArgsFromRun));
        ArrayList<AppConfigurer> apps = new ArrayList<AppConfigurer>();
        if (this.sourceConfigurer != null) {
            apps.add(this.sourceConfigurer);
        }
        if (!this.processorConfigurers.isEmpty()) {
            for (ProcessorConfigurer processorConfigurer : this.processorConfigurers) {
                apps.add(processorConfigurer);
            }
        }
        if (this.sinkConfigurer != null) {
            apps.add(this.sinkConfigurer);
        }
        LinkedHashMap appsToEmbed = new LinkedHashMap();
        for (int i = 0; i < apps.size(); ++i) {
            AppConfigurer appConfigurer = (AppConfigurer)apps.get(i);
            Class<?> appToEmbed = appConfigurer.getApp();
            if (appConfigurer.namespace == null) {
                appConfigurer.namespace = AggregateApplication.getDefaultNamespace(appConfigurer.getApp().getName(), i);
            }
            appsToEmbed.put(appToEmbed, appConfigurer.namespace);
        }
        this.parentContext = AggregateApplication.createParentContext(this.parentSources.toArray(new Object[0]), this.parentArgs.toArray(new String[0]), this.selfContained(), this.webEnvironment, this.headless);
        SharedChannelRegistry sharedChannelRegistry = (SharedChannelRegistry)this.parentContext.getBean(SharedChannelRegistry.class);
        AggregateApplication.prepareSharedChannelRegistry(sharedChannelRegistry, appsToEmbed);
        for (int i = apps.size() - 1; i >= 0; --i) {
            AppConfigurer appConfigurer = (AppConfigurer)apps.get(i);
            appConfigurer.embed();
        }
        return this.parentContext;
    }

    private boolean selfContained() {
        return this.sourceConfigurer != null && this.sinkConfigurer != null;
    }

    private ChildContextBuilder childContext(Class<?> app, ConfigurableApplicationContext parentContext, String namespace) {
        return new ChildContextBuilder(AggregateApplication.embedApp(parentContext, namespace, app));
    }

    @EnableAutoConfiguration
    @EnableBinding
    public static class ParentConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={SharedChannelRegistry.class})
        public SharedChannelRegistry sharedChannelRegistry() {
            return new SharedChannelRegistry();
        }
    }

    private final class ChildContextBuilder {
        private SpringApplicationBuilder builder;
        private String configName;
        private String[] args;

        private ChildContextBuilder(SpringApplicationBuilder builder) {
            this.builder = builder;
        }

        public ChildContextBuilder profiles(String ... profiles) {
            if (profiles != null) {
                this.builder.profiles(profiles);
            }
            return this;
        }

        public ChildContextBuilder config(String ... configs) {
            if (configs != null) {
                this.configName = StringUtils.arrayToCommaDelimitedString((Object[])configs);
            }
            return this;
        }

        public ChildContextBuilder args(String ... args) {
            this.args = args;
            return this;
        }

        public ConfigurableApplicationContext run() {
            ArrayList<String> args = new ArrayList<String>();
            if (this.args != null) {
                args.addAll(Arrays.asList(this.args));
            }
            if (this.configName != null) {
                args.add("--spring.config.name=" + this.configName);
            }
            return this.builder.run(args.toArray(new String[0]));
        }
    }

    public abstract class AppConfigurer<T extends AppConfigurer<T>> {
        Class<?> app;
        String[] args;
        String[] names;
        String[] profiles;
        String namespace;

        Class<?> getApp() {
            return this.app;
        }

        public T as(String ... names) {
            this.names = names;
            return this.getConfigurer();
        }

        public T args(String ... args) {
            this.args = args;
            return this.getConfigurer();
        }

        public T profiles(String ... profiles) {
            this.profiles = profiles;
            return this.getConfigurer();
        }

        private T getConfigurer() {
            return (T)this;
        }

        public T namespace(String namespace) {
            this.namespace = namespace;
            return this.getConfigurer();
        }

        public ConfigurableApplicationContext run(String ... args) {
            return AggregateApplicationBuilder.this.applicationBuilder.run(args);
        }

        void embed() {
            ConfigurableApplicationContext childContext = AggregateApplicationBuilder.this.childContext(this.app, AggregateApplicationBuilder.this.parentContext, this.namespace).args(this.args).config(this.names).profiles(this.profiles).run();
            ((MetricsEndpoint)AggregateApplicationBuilder.this.parentContext.getBeanFactory().getBean(MetricsEndpoint.class)).registerPublicMetrics((PublicMetrics)new MetricReaderPublicMetrics((MetricReader)new NamespaceAwareSpringIntegrationMetricReader(this.namespace, (IntegrationMBeanExporter)childContext.getBean(IntegrationMBeanExporter.class))));
        }
    }

    public class ProcessorConfigurer
    extends AppConfigurer<ProcessorConfigurer> {
        public ProcessorConfigurer(Class<?> app) {
            this.app = app;
            AggregateApplicationBuilder.this.processorConfigurers.add(this);
        }

        public SinkConfigurer to(Class<?> sink) {
            return new SinkConfigurer(sink);
        }

        public ProcessorConfigurer via(Class<?> processor) {
            return new ProcessorConfigurer(processor);
        }
    }

    public class SinkConfigurer
    extends AppConfigurer<SinkConfigurer> {
        public SinkConfigurer(Class<?> app) {
            this.app = app;
            AggregateApplicationBuilder.this.sinkConfigurer = this;
        }
    }

    public class SourceConfigurer
    extends AppConfigurer<SourceConfigurer> {
        public SourceConfigurer(Class<?> app) {
            this.app = app;
            AggregateApplicationBuilder.this.sourceConfigurer = this;
        }

        public SinkConfigurer to(Class<?> sink) {
            return new SinkConfigurer(sink);
        }

        public ProcessorConfigurer via(Class<?> processor) {
            return new ProcessorConfigurer(processor);
        }
    }
}

