/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.stream.converter.AbstractFromMessageConverter;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.messaging.Message;
import org.springframework.tuple.Tuple;
import org.springframework.tuple.TupleBuilder;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public class JsonToTupleMessageConverter
extends AbstractFromMessageConverter {
    private static final List<MimeType> targetMimeTypes = new ArrayList<MimeType>();

    public JsonToTupleMessageConverter() {
        super(MimeTypeUtils.APPLICATION_JSON, targetMimeTypes);
    }

    @Override
    protected Class<?>[] supportedTargetTypes() {
        return new Class[]{Tuple.class};
    }

    @Override
    protected Class<?>[] supportedPayloadTypes() {
        return new Class[]{byte[].class, String.class};
    }

    public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        String source = null;
        source = message.getPayload() instanceof byte[] ? new String((byte[])message.getPayload()) : (String)message.getPayload();
        return TupleBuilder.fromString((String)source);
    }

    static {
        targetMimeTypes.add(MessageConverterUtils.X_SPRING_TUPLE);
        targetMimeTypes.add(MessageConverterUtils.X_JAVA_OBJECT);
    }
}

