/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.test;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binder.test.TestChannelBinder;
import org.springframework.cloud.stream.binding.BindableProxyFactory;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.messaging.MessageChannel;

public final class FunctionBindingTestUtils {
    private FunctionBindingTestUtils() {
    }

    public static void bind(ConfigurableApplicationContext applicationContext, Object function) {
        try {
            Object targetFunction = function;
            if (function instanceof FunctionRegistration) {
                targetFunction = ((FunctionRegistration)function).getTarget();
            }
            String functionName = targetFunction instanceof Function ? "function" : (targetFunction instanceof Consumer ? "consumer" : "supplier");
            System.setProperty("spring.cloud.function.definition", functionName);
            applicationContext.getBeanFactory().registerSingleton(functionName, function);
            Object actualFunction = ((SimpleFunctionRegistry.FunctionInvocationWrapper)((FunctionCatalog)applicationContext.getBean(FunctionCatalog.class)).lookup(functionName)).getTarget();
            InitializingBean functionBindingRegistrar = (InitializingBean)applicationContext.getBean("functionBindingRegistrar", InitializingBean.class);
            functionBindingRegistrar.afterPropertiesSet();
            BindableProxyFactory bindingProxy = (BindableProxyFactory)applicationContext.getBean("&" + functionName + "_binding", BindableProxyFactory.class);
            bindingProxy.afterPropertiesSet();
            InitializingBean functionBinder = (InitializingBean)applicationContext.getBean("functionInitializer", InitializingBean.class);
            functionBinder.afterPropertiesSet();
            BindingServiceProperties bindingProperties = (BindingServiceProperties)applicationContext.getBean(BindingServiceProperties.class);
            String inputBindingName = functionName + "-in-0";
            String outputBindingName = functionName + "-out-0";
            Map bindings = bindingProperties.getBindings();
            BindingProperties inputProperties = (BindingProperties)bindings.get(inputBindingName);
            BindingProperties outputProperties = (BindingProperties)bindings.get(outputBindingName);
            ConsumerProperties consumerProperties = inputProperties.getConsumer();
            ProducerProperties producerProperties = outputProperties.getProducer();
            TestChannelBinder binder = (TestChannelBinder)((Object)applicationContext.getBean(TestChannelBinder.class));
            if (actualFunction instanceof Supplier || actualFunction instanceof Function) {
                Binding bindProducer = binder.bindProducer(outputProperties.getDestination(), (MessageChannel)applicationContext.getBean(outputBindingName, MessageChannel.class), producerProperties == null ? new ProducerProperties() : producerProperties);
                bindProducer.start();
            }
            if (actualFunction instanceof Consumer || actualFunction instanceof Function) {
                Binding bindConsumer = binder.bindConsumer(inputProperties.getDestination(), null, (MessageChannel)applicationContext.getBean(inputBindingName, MessageChannel.class), consumerProperties == null ? new ConsumerProperties() : consumerProperties);
                bindConsumer.start();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to bind function", e);
        }
        finally {
            System.clearProperty("spring.cloud.function.definition");
        }
    }
}

