/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.server.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.schema.server.config.SchemaServerProperties;
import org.springframework.cloud.stream.schema.server.controllers.ServerController;
import org.springframework.cloud.stream.schema.server.model.Schema;
import org.springframework.cloud.stream.schema.server.repository.SchemaRepository;
import org.springframework.cloud.stream.schema.server.support.AvroSchemaValidator;
import org.springframework.cloud.stream.schema.server.support.SchemaValidator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Configuration
@EnableJpaRepositories(basePackageClasses={SchemaRepository.class})
@EnableConfigurationProperties(value={SchemaServerProperties.class})
@Import(value={ServerController.class})
public class SchemaServerConfiguration {
    @Bean
    public static BeanFactoryPostProcessor entityScanPackagesPostProcessor() {
        return new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                if (beanFactory instanceof BeanDefinitionRegistry) {
                    EntityScanPackages.register((BeanDefinitionRegistry)((BeanDefinitionRegistry)beanFactory), Collections.singletonList(Schema.class.getPackage().getName()));
                }
            }
        };
    }

    @Bean
    public Map<String, SchemaValidator> schemaValidators() {
        HashMap<String, SchemaValidator> validatorMap = new HashMap<String, SchemaValidator>();
        validatorMap.put("avro", new AvroSchemaValidator());
        return validatorMap;
    }
}

