/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.registry.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.springframework.cloud.stream.schema.registry.avro.AvroSchemaServiceManager;
import org.springframework.cloud.stream.schema.registry.avro.AvroSchemaServiceManagerImpl;
import org.springframework.cloud.stream.schema.registry.avro.OriginalContentTypeResolver;
import org.springframework.core.io.Resource;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.MimeType;

public abstract class AbstractAvroMessageConverter
extends AbstractMessageConverter {
    private Schema.Parser schemaParser = new Schema.Parser();
    private AvroSchemaServiceManager avroSchemaServiceManager;

    @Deprecated
    protected AbstractAvroMessageConverter(MimeType supportedMimeType) {
        this(Collections.singletonList(supportedMimeType), (AvroSchemaServiceManager)new AvroSchemaServiceManagerImpl());
    }

    protected AbstractAvroMessageConverter(MimeType supportedMimeType, AvroSchemaServiceManager avroSchemaServiceManager) {
        this(Collections.singletonList(supportedMimeType), avroSchemaServiceManager);
    }

    @Deprecated
    protected AbstractAvroMessageConverter(Collection<MimeType> supportedMimeTypes) {
        this(supportedMimeTypes, (AvroSchemaServiceManager)new AvroSchemaServiceManagerImpl());
        this.setContentTypeResolver(new OriginalContentTypeResolver());
    }

    protected AbstractAvroMessageConverter(Collection<MimeType> supportedMimeTypes, AvroSchemaServiceManager manager) {
        super(supportedMimeTypes);
        this.setContentTypeResolver(new OriginalContentTypeResolver());
        this.avroSchemaServiceManager = manager;
    }

    protected AvroSchemaServiceManager avroSchemaServiceManager() {
        return this.avroSchemaServiceManager;
    }

    protected Schema parseSchema(Resource r) throws IOException {
        return this.schemaParser.parse(r.getInputStream());
    }

    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        return super.canConvertFrom(message, targetClass) && message.getPayload() instanceof byte[];
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        Object result;
        try {
            byte[] payload = (byte[])message.getPayload();
            MimeType mimeType = this.getContentTypeResolver().resolve(message.getHeaders());
            if (mimeType == null) {
                if (conversionHint instanceof MimeType) {
                    mimeType = (MimeType)conversionHint;
                } else {
                    return null;
                }
            }
            Schema writerSchema = this.resolveWriterSchemaForDeserialization(mimeType);
            Schema readerSchema = this.resolveReaderSchemaForDeserialization(targetClass);
            result = this.avroSchemaServiceManager().readData(targetClass, payload, readerSchema, writerSchema);
        }
        catch (IOException e) {
            throw new MessageConversionException(message, "Failed to read payload", (Throwable)e);
        }
        return result;
    }

    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MimeType hintedContentType = null;
            if (conversionHint instanceof MimeType) {
                hintedContentType = (MimeType)conversionHint;
            }
            Schema schema = this.resolveSchemaForWriting(payload, headers, hintedContentType);
            DatumWriter<Object> writer = this.avroSchemaServiceManager().getDatumWriter(payload.getClass(), schema);
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
            writer.write(payload, (Encoder)encoder);
            encoder.flush();
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to write payload", (Throwable)e);
        }
        return baos.toByteArray();
    }

    protected abstract Schema resolveSchemaForWriting(Object var1, MessageHeaders var2, MimeType var3);

    protected abstract Schema resolveWriterSchemaForDeserialization(MimeType var1);

    protected abstract Schema resolveReaderSchemaForDeserialization(Class<?> var1);
}

