/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.redis.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.redis.RedisMessageChannelBinder;
import org.springframework.cloud.stream.config.codec.kryo.KryoCodecAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.integration.codec.Codec;

@Configuration
@Import(value={PropertyPlaceholderAutoConfiguration.class, KryoCodecAutoConfiguration.class})
@ConfigurationProperties(prefix="spring.cloud.stream.redis.binder")
public class RedisMessageChannelBinderConfiguration {
    private String[] headers;
    @Autowired
    private Codec codec;
    @Autowired
    private RedisConnectionFactory redisConnectionFactory;

    @Bean
    public RedisMessageChannelBinder redisMessageChannelBinder() {
        RedisMessageChannelBinder redisMessageChannelBinder = new RedisMessageChannelBinder(this.redisConnectionFactory, this.headers);
        redisMessageChannelBinder.setCodec(this.codec);
        return redisMessageChannelBinder;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }
}

