/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kinesis.properties;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.integration.aws.lock.DynamoDbLockRepository;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;

@ConfigurationProperties(prefix="spring.cloud.stream.kinesis.binder")
public class KinesisBinderConfigurationProperties {
    private String[] headers = new String[0];
    private int describeStreamBackoff = 1000;
    private int describeStreamRetries = 50;
    private boolean autoCreateStream = true;
    private boolean autoAddShards = false;
    private int minShardCount = 1;
    private boolean kplKclEnabled;
    private boolean enableObservation;
    private boolean legacyEmbeddedHeadersFormat;
    private final Checkpoint checkpoint = new Checkpoint();
    private final Locks locks = new Locks();

    public String[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(String ... headers) {
        this.headers = headers;
    }

    public int getDescribeStreamBackoff() {
        return this.describeStreamBackoff;
    }

    public void setDescribeStreamBackoff(int describeStreamBackoff) {
        this.describeStreamBackoff = describeStreamBackoff;
    }

    public int getDescribeStreamRetries() {
        return this.describeStreamRetries;
    }

    public void setDescribeStreamRetries(int describeStreamRetries) {
        this.describeStreamRetries = describeStreamRetries;
    }

    public boolean isAutoAddShards() {
        return this.autoAddShards;
    }

    public void setAutoAddShards(boolean autoAddShards) {
        this.autoAddShards = autoAddShards;
    }

    public int getMinShardCount() {
        return this.minShardCount;
    }

    public void setMinShardCount(int minShardCount) {
        this.minShardCount = minShardCount;
    }

    public Checkpoint getCheckpoint() {
        return this.checkpoint;
    }

    public Locks getLocks() {
        return this.locks;
    }

    public boolean isAutoCreateStream() {
        return this.autoCreateStream;
    }

    public void setAutoCreateStream(boolean autoCreateStream) {
        this.autoCreateStream = autoCreateStream;
    }

    public boolean isKplKclEnabled() {
        return this.kplKclEnabled;
    }

    public void setKplKclEnabled(boolean kplKclEnabled) {
        this.kplKclEnabled = kplKclEnabled;
    }

    public boolean isEnableObservation() {
        return this.enableObservation;
    }

    public void setEnableObservation(boolean enableObservation) {
        this.enableObservation = enableObservation;
    }

    public boolean isLegacyEmbeddedHeadersFormat() {
        return this.legacyEmbeddedHeadersFormat;
    }

    public void setLegacyEmbeddedHeadersFormat(boolean legacyEmbeddedHeadersFormat) {
        this.legacyEmbeddedHeadersFormat = legacyEmbeddedHeadersFormat;
    }

    public static class Checkpoint {
        private String table = "SpringIntegrationMetadataStore";
        private BillingMode billingMode = BillingMode.PAY_PER_REQUEST;
        private long readCapacity = 1L;
        private long writeCapacity = 1L;
        private int createDelay = 1;
        private int createRetries = 25;
        private Integer timeToLive;

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public BillingMode getBillingMode() {
            return this.billingMode;
        }

        public void setBillingMode(BillingMode billingMode) {
            this.billingMode = billingMode;
        }

        public long getReadCapacity() {
            return this.readCapacity;
        }

        public void setReadCapacity(long readCapacity) {
            this.readCapacity = readCapacity;
        }

        public long getWriteCapacity() {
            return this.writeCapacity;
        }

        public void setWriteCapacity(long writeCapacity) {
            this.writeCapacity = writeCapacity;
        }

        public int getCreateDelay() {
            return this.createDelay;
        }

        public void setCreateDelay(int createDelay) {
            this.createDelay = createDelay;
        }

        public int getCreateRetries() {
            return this.createRetries;
        }

        public void setCreateRetries(int createRetries) {
            this.createRetries = createRetries;
        }

        public Integer getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }
    }

    public static class Locks {
        private String table = "SpringIntegrationLockRegistry";
        private BillingMode billingMode = BillingMode.PAY_PER_REQUEST;
        private long readCapacity = 1L;
        private long writeCapacity = 1L;
        private Duration refreshPeriod = Duration.ofSeconds(1L);
        private Duration leaseDuration = DynamoDbLockRepository.DEFAULT_LEASE_DURATION;

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public BillingMode getBillingMode() {
            return this.billingMode;
        }

        public void setBillingMode(BillingMode billingMode) {
            this.billingMode = billingMode;
        }

        public long getReadCapacity() {
            return this.readCapacity;
        }

        public void setReadCapacity(long readCapacity) {
            this.readCapacity = readCapacity;
        }

        public long getWriteCapacity() {
            return this.writeCapacity;
        }

        public void setWriteCapacity(long writeCapacity) {
            this.writeCapacity = writeCapacity;
        }

        public Duration getRefreshPeriod() {
            return this.refreshPeriod;
        }

        public void setRefreshPeriod(Duration refreshPeriod) {
            this.refreshPeriod = refreshPeriod;
        }

        public Duration getLeaseDuration() {
            return this.leaseDuration;
        }

        public void setLeaseDuration(Duration leaseDuration) {
            this.leaseDuration = leaseDuration;
        }
    }
}

