/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kinesis;

import java.util.Map;
import org.springframework.cloud.stream.binder.EmbeddedHeaderUtils;
import org.springframework.cloud.stream.binder.MessageValues;
import org.springframework.integration.mapping.BytesMessageMapper;
import org.springframework.integration.support.json.EmbeddedJsonHeadersMessageMapper;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;

class LegacyEmbeddedHeadersSupportBytesMessageMapper
implements BytesMessageMapper {
    private final EmbeddedJsonHeadersMessageMapper delegate;
    private final String[] headersToEmbed;
    private final boolean legacyEmbeddedHeadersFormat;

    LegacyEmbeddedHeadersSupportBytesMessageMapper(boolean legacyEmbeddedHeadersFormat, String[] headersToEmbed) {
        this.legacyEmbeddedHeadersFormat = legacyEmbeddedHeadersFormat;
        this.delegate = new EmbeddedJsonHeadersMessageMapper(headersToEmbed);
        this.headersToEmbed = headersToEmbed;
    }

    public Message<?> toMessage(byte[] payload, @Nullable Map<String, Object> headers) {
        if (EmbeddedHeaderUtils.mayHaveEmbeddedHeaders((byte[])payload)) {
            try {
                MessageValues messageValues = EmbeddedHeaderUtils.extractHeaders((byte[])payload);
                if (headers != null) {
                    messageValues.copyHeadersIfAbsent(headers);
                }
                return messageValues.toMessage();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.delegate.toMessage(payload, headers);
    }

    public byte[] fromMessage(Message<?> message) {
        if (this.legacyEmbeddedHeadersFormat) {
            MessageValues transformed = new MessageValues(message);
            Object contentType = transformed.get((Object)"contentType");
            if (contentType != null) {
                transformed.put("contentType", (Object)contentType.toString());
            }
            return EmbeddedHeaderUtils.embedHeaders((MessageValues)transformed, (String[])this.headersToEmbed);
        }
        return this.delegate.fromMessage(message);
    }
}

