/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kinesis.adapter;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.model.AmazonDynamoDBException;
import com.amazonaws.services.dynamodbv2.streamsadapter.AmazonDynamoDBStreamsAdapterClient;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.InvalidArgumentException;
import com.amazonaws.services.kinesis.model.ListShardsRequest;
import com.amazonaws.services.kinesis.model.ListShardsResult;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.StreamDescription;
import java.util.Collection;

public class SpringDynamoDBAdapterClient
extends AmazonDynamoDBStreamsAdapterClient {
    private static final String SEPARATOR = "!!##%%";

    public SpringDynamoDBAdapterClient(AmazonDynamoDBStreams amazonDynamoDBStreams) {
        super(amazonDynamoDBStreams);
    }

    public ListShardsResult listShards(ListShardsRequest request) {
        try {
            if (request.getNextToken() != null && request.getStreamName() != null) {
                throw new InvalidArgumentException("NextToken and StreamName cannot be provided together.");
            }
            String streamName = request.getStreamName();
            String exclusiveStartShardId = request.getExclusiveStartShardId();
            if (request.getNextToken() != null) {
                String[] split = request.getNextToken().split(SEPARATOR);
                if (split.length != 2) {
                    throw new InvalidArgumentException("Invalid ShardIterator");
                }
                streamName = split[0];
                exclusiveStartShardId = split[1];
            }
            DescribeStreamRequest dsr = new DescribeStreamRequest().withStreamName(streamName).withExclusiveStartShardId(exclusiveStartShardId).withLimit(request.getMaxResults());
            StreamDescription streamDescription = this.describeStream(dsr).getStreamDescription();
            ListShardsResult result = new ListShardsResult().withShards((Collection)streamDescription.getShards());
            if (streamDescription.getHasMoreShards().booleanValue()) {
                result.withNextToken(this.buildFakeNextToken(streamName, ((Shard)streamDescription.getShards().get(streamDescription.getShards().size() - 1)).getShardId()));
            }
            return result;
        }
        catch (AmazonDynamoDBException ex) {
            ResourceNotFoundException resourceEx = new ResourceNotFoundException(ex.getMessage());
            resourceEx.setStackTrace(ex.getStackTrace());
            throw resourceEx;
        }
    }

    private String buildFakeNextToken(String streamName, String lastShard) {
        return lastShard != null ? streamName + SEPARATOR + lastShard : null;
    }
}

