/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kinesis.properties;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kinesis.properties.KinesisBindingProperties;
import org.springframework.cloud.stream.binder.kinesis.properties.KinesisConsumerProperties;
import org.springframework.cloud.stream.binder.kinesis.properties.KinesisProducerProperties;

@ConfigurationProperties(value="spring.cloud.stream.kinesis")
public class KinesisExtendedBindingProperties
implements ExtendedBindingProperties<KinesisConsumerProperties, KinesisProducerProperties> {
    private static final String DEFAULTS_PREFIX = "spring.cloud.stream.kinesis.default";
    private Map<String, KinesisBindingProperties> bindings = new HashMap<String, KinesisBindingProperties>();

    public Map<String, KinesisBindingProperties> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, KinesisBindingProperties> bindings) {
        this.bindings = bindings;
    }

    public KinesisConsumerProperties getExtendedConsumerProperties(String channelName) {
        if (this.bindings.containsKey(channelName) && this.bindings.get(channelName).getConsumer() != null) {
            return this.bindings.get(channelName).getConsumer();
        }
        return new KinesisConsumerProperties();
    }

    public KinesisProducerProperties getExtendedProducerProperties(String channelName) {
        if (this.bindings.containsKey(channelName) && this.bindings.get(channelName).getProducer() != null) {
            return this.bindings.get(channelName).getProducer();
        }
        return new KinesisProducerProperties();
    }

    public String getDefaultsPrefix() {
        return DEFAULTS_PREFIX;
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return KinesisBindingProperties.class;
    }
}

