/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.config;

import java.util.HashMap;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.stream.binder.kafka.KafkaBinderHealthIndicator;
import org.springframework.cloud.stream.binder.kafka.KafkaMessageChannelBinder;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.util.ObjectUtils;

@Configuration
@ConditionalOnClass(name={"org.springframework.boot.actuate.health.HealthIndicator"})
class KafkaBinderHealthIndicatorConfiguration {
    KafkaBinderHealthIndicatorConfiguration() {
    }

    @Bean
    KafkaBinderHealthIndicator healthIndicator(KafkaMessageChannelBinder kafkaMessageChannelBinder, KafkaBinderConfigurationProperties configurationProperties) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("key.deserializer", ByteArrayDeserializer.class);
        props.put("value.deserializer", ByteArrayDeserializer.class);
        if (!ObjectUtils.isEmpty((Object)configurationProperties.getConsumerConfiguration())) {
            props.putAll(configurationProperties.getConsumerConfiguration());
        }
        if (!props.containsKey("bootstrap.servers")) {
            props.put("bootstrap.servers", configurationProperties.getKafkaConnectionString());
        }
        DefaultKafkaConsumerFactory consumerFactory = new DefaultKafkaConsumerFactory(props);
        KafkaBinderHealthIndicator indicator = new KafkaBinderHealthIndicator(kafkaMessageChannelBinder, (ConsumerFactory<?, ?>)consumerFactory);
        indicator.setTimeout(configurationProperties.getHealthTimeout());
        return indicator;
    }
}

