/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka;

import java.util.HashMap;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class KafkaBinderEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    public static final String SPRING_KAFKA = "spring.kafka";
    public static final String SPRING_KAFKA_PRODUCER = "spring.kafka.producer";
    public static final String SPRING_KAFKA_CONSUMER = "spring.kafka.consumer";
    public static final String SPRING_KAFKA_PRODUCER_KEY_SERIALIZER = "spring.kafka.producer.keySerializer";
    public static final String SPRING_KAFKA_PRODUCER_VALUE_SERIALIZER = "spring.kafka.producer.valueSerializer";
    public static final String SPRING_KAFKA_CONSUMER_KEY_DESERIALIZER = "spring.kafka.consumer.keyDeserializer";
    public static final String SPRING_KAFKA_CONSUMER_VALUE_DESERIALIZER = "spring.kafka.consumer.valueDeserializer";
    private static final String KAFKA_BINDER_DEFAULT_PROPERTIES = "kafkaBinderDefaultProperties";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!environment.getPropertySources().contains(KAFKA_BINDER_DEFAULT_PROPERTIES)) {
            HashMap<String, String> kafkaBinderDefaultProperties = new HashMap<String, String>();
            kafkaBinderDefaultProperties.put("logging.level.org.I0Itec.zkclient", "ERROR");
            kafkaBinderDefaultProperties.put("logging.level.kafka.server.KafkaConfig", "ERROR");
            kafkaBinderDefaultProperties.put("logging.level.kafka.admin.AdminClient.AdminConfig", "ERROR");
            kafkaBinderDefaultProperties.put(SPRING_KAFKA_PRODUCER_KEY_SERIALIZER, ByteArraySerializer.class.getName());
            kafkaBinderDefaultProperties.put(SPRING_KAFKA_PRODUCER_VALUE_SERIALIZER, ByteArraySerializer.class.getName());
            kafkaBinderDefaultProperties.put(SPRING_KAFKA_CONSUMER_KEY_DESERIALIZER, ByteArrayDeserializer.class.getName());
            kafkaBinderDefaultProperties.put(SPRING_KAFKA_CONSUMER_VALUE_DESERIALIZER, ByteArrayDeserializer.class.getName());
            environment.getPropertySources().addLast((PropertySource)new MapPropertySource(KAFKA_BINDER_DEFAULT_PROPERTIES, kafkaBinderDefaultProperties));
        }
    }
}

