/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.properties;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.DeserializationExceptionHandler;

public class KafkaStreamsBinderConfigurationProperties
extends KafkaBinderConfigurationProperties {
    private String applicationId;
    private StateStoreRetry stateStoreRetry = new StateStoreRetry();
    private Map<String, Functions> functions = new HashMap<String, Functions>();
    private SerdeError serdeError;
    private DeserializationExceptionHandler deserializationExceptionHandler;
    private boolean includeStoppedProcessorsForHealthCheck;

    public KafkaStreamsBinderConfigurationProperties(KafkaProperties kafkaProperties) {
        super(kafkaProperties);
    }

    public Map<String, Functions> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Map<String, Functions> functions) {
        this.functions = functions;
    }

    public StateStoreRetry getStateStoreRetry() {
        return this.stateStoreRetry;
    }

    public void setStateStoreRetry(StateStoreRetry stateStoreRetry) {
        this.stateStoreRetry = stateStoreRetry;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Deprecated
    public SerdeError getSerdeError() {
        return this.serdeError;
    }

    @Deprecated
    public void setSerdeError(SerdeError serdeError) {
        this.serdeError = serdeError;
        if (serdeError == SerdeError.logAndContinue) {
            this.deserializationExceptionHandler = DeserializationExceptionHandler.logAndContinue;
        } else if (serdeError == SerdeError.logAndFail) {
            this.deserializationExceptionHandler = DeserializationExceptionHandler.logAndFail;
        } else if (serdeError == SerdeError.sendToDlq) {
            this.deserializationExceptionHandler = DeserializationExceptionHandler.sendToDlq;
        }
    }

    public DeserializationExceptionHandler getDeserializationExceptionHandler() {
        return this.deserializationExceptionHandler;
    }

    public void setDeserializationExceptionHandler(DeserializationExceptionHandler deserializationExceptionHandler) {
        this.deserializationExceptionHandler = deserializationExceptionHandler;
    }

    public boolean isIncludeStoppedProcessorsForHealthCheck() {
        return this.includeStoppedProcessorsForHealthCheck;
    }

    public void setIncludeStoppedProcessorsForHealthCheck(boolean includeStoppedProcessorsForHealthCheck) {
        this.includeStoppedProcessorsForHealthCheck = includeStoppedProcessorsForHealthCheck;
    }

    public static class Functions {
        private String applicationId;
        private Map<String, String> configuration;

        public String getApplicationId() {
            return this.applicationId;
        }

        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public Map<String, String> getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(Map<String, String> configuration) {
            this.configuration = configuration;
        }
    }

    public static class StateStoreRetry {
        private int maxAttempts = 1;
        private long backoffPeriod = 1000L;

        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        public void setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        public long getBackoffPeriod() {
            return this.backoffPeriod;
        }

        public void setBackoffPeriod(long backoffPeriod) {
            this.backoffPeriod = backoffPeriod;
        }
    }

    @Deprecated
    public static enum SerdeError {
        logAndContinue,
        logAndFail,
        sendToDlq;

    }
}

