/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Set;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBinderMetrics;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsRegistry;
import org.springframework.context.SmartLifecycle;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.streams.KafkaStreamsMicrometerListener;

class StreamsBuilderFactoryManager
implements SmartLifecycle {
    private final KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue;
    private final KafkaStreamsRegistry kafkaStreamsRegistry;
    private final KafkaStreamsBinderMetrics kafkaStreamsBinderMetrics;
    private final KafkaStreamsMicrometerListener listener;
    private volatile boolean running;

    StreamsBuilderFactoryManager(KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue, KafkaStreamsRegistry kafkaStreamsRegistry, KafkaStreamsBinderMetrics kafkaStreamsBinderMetrics, KafkaStreamsMicrometerListener listener) {
        this.kafkaStreamsBindingInformationCatalogue = kafkaStreamsBindingInformationCatalogue;
        this.kafkaStreamsRegistry = kafkaStreamsRegistry;
        this.kafkaStreamsBinderMetrics = kafkaStreamsBinderMetrics;
        this.listener = listener;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        if (callback != null) {
            callback.run();
        }
    }

    public synchronized void start() {
        if (!this.running) {
            try {
                Set<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans = this.kafkaStreamsBindingInformationCatalogue.getStreamsBuilderFactoryBeans();
                boolean n = false;
                for (StreamsBuilderFactoryBean streamsBuilderFactoryBean : streamsBuilderFactoryBeans) {
                    streamsBuilderFactoryBean.addListener((StreamsBuilderFactoryBean.Listener)this.listener);
                    streamsBuilderFactoryBean.start();
                    this.kafkaStreamsRegistry.registerKafkaStreams(streamsBuilderFactoryBean);
                }
                if (this.kafkaStreamsBinderMetrics != null) {
                    this.kafkaStreamsBinderMetrics.addMetrics(streamsBuilderFactoryBeans);
                }
                this.running = true;
            }
            catch (Exception ex) {
                throw new KafkaException("Could not start stream: ", (Throwable)ex);
            }
        }
    }

    public synchronized void stop() {
        if (this.running) {
            try {
                Set<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans = this.kafkaStreamsBindingInformationCatalogue.getStreamsBuilderFactoryBeans();
                boolean n = false;
                for (StreamsBuilderFactoryBean streamsBuilderFactoryBean : streamsBuilderFactoryBeans) {
                    streamsBuilderFactoryBean.removeListener((StreamsBuilderFactoryBean.Listener)this.listener);
                    streamsBuilderFactoryBean.stop();
                }
                for (ProducerFactory producerFactory : this.kafkaStreamsBindingInformationCatalogue.getDlqProducerFactories()) {
                    ((DisposableBean)producerFactory).destroy();
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
            finally {
                this.running = false;
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 2147483547;
    }
}

