/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.KStream;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsConsumerProperties;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.core.ResolvableType;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;

class KafkaStreamsBindingInformationCatalogue {
    private final Map<KStream<?, ?>, BindingProperties> bindingProperties = new ConcurrentHashMap();
    private final Map<KStream<?, ?>, KafkaStreamsConsumerProperties> consumerProperties = new ConcurrentHashMap();
    private final Set<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans = new HashSet<StreamsBuilderFactoryBean>();
    private final Map<Object, ResolvableType> outboundKStreamResolvables = new HashMap<Object, ResolvableType>();
    private final Map<KStream<?, ?>, Serde<?>> keySerdeInfo = new HashMap();
    private final Map<Object, String> bindingNamesPerTarget = new HashMap<Object, String>();

    KafkaStreamsBindingInformationCatalogue() {
    }

    String getDestination(KStream<?, ?> bindingTarget) {
        BindingProperties bindingProperties = this.bindingProperties.get(bindingTarget);
        return bindingProperties.getDestination();
    }

    boolean isUseNativeDecoding(KStream<?, ?> bindingTarget) {
        BindingProperties bindingProperties = this.bindingProperties.get(bindingTarget);
        if (bindingProperties.getConsumer() == null) {
            bindingProperties.setConsumer(new ConsumerProperties());
        }
        return bindingProperties.getConsumer().isUseNativeDecoding();
    }

    boolean isDlqEnabled(KStream<?, ?> bindingTarget) {
        return this.consumerProperties.get(bindingTarget).isEnableDlq();
    }

    String getContentType(KStream<?, ?> bindingTarget) {
        BindingProperties bindingProperties = this.bindingProperties.get(bindingTarget);
        return bindingProperties.getContentType();
    }

    void registerBindingProperties(KStream<?, ?> bindingTarget, BindingProperties bindingProperties) {
        if (bindingProperties != null) {
            this.bindingProperties.put(bindingTarget, bindingProperties);
        }
    }

    void registerConsumerProperties(KStream<?, ?> bindingTarget, KafkaStreamsConsumerProperties kafkaStreamsConsumerProperties) {
        if (kafkaStreamsConsumerProperties != null) {
            this.consumerProperties.put(bindingTarget, kafkaStreamsConsumerProperties);
        }
    }

    void addStreamBuilderFactory(StreamsBuilderFactoryBean streamsBuilderFactoryBean) {
        this.streamsBuilderFactoryBeans.add(streamsBuilderFactoryBean);
    }

    Set<StreamsBuilderFactoryBean> getStreamsBuilderFactoryBeans() {
        return this.streamsBuilderFactoryBeans;
    }

    void addOutboundKStreamResolvable(Object key, ResolvableType outboundResolvable) {
        this.outboundKStreamResolvables.put(key, outboundResolvable);
    }

    ResolvableType getOutboundKStreamResolvable(Object key) {
        return this.outboundKStreamResolvables.get(key);
    }

    void addKeySerde(KStream<?, ?> kStreamTarget, Serde<?> keySerde) {
        this.keySerdeInfo.put(kStreamTarget, keySerde);
    }

    Serde<?> getKeySerde(KStream<?, ?> kStreamTarget) {
        return this.keySerdeInfo.get(kStreamTarget);
    }

    Map<KStream<?, ?>, BindingProperties> getBindingProperties() {
        return this.bindingProperties;
    }

    Map<KStream<?, ?>, KafkaStreamsConsumerProperties> getConsumerProperties() {
        return this.consumerProperties;
    }

    void addBindingNamePerTarget(Object target, String bindingName) {
        this.bindingNamesPerTarget.put(target, bindingName);
    }

    String bindingNamePerTarget(Object target) {
        return this.bindingNamesPerTarget.get(target);
    }
}

