/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.errors.LogAndContinueExceptionHandler;
import org.apache.kafka.streams.errors.LogAndFailExceptionHandler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.kafka.streams.DeserializationExceptionHandler;
import org.springframework.cloud.stream.binder.kafka.streams.EncodingDecodingBindAdviceHandler;
import org.springframework.cloud.stream.binder.kafka.streams.GlobalKTableBoundElementFactory;
import org.springframework.cloud.stream.binder.kafka.streams.InteractiveQueryService;
import org.springframework.cloud.stream.binder.kafka.streams.KStreamBoundElementFactory;
import org.springframework.cloud.stream.binder.kafka.streams.KStreamStreamListenerParameterAdapter;
import org.springframework.cloud.stream.binder.kafka.streams.KStreamStreamListenerResultAdapter;
import org.springframework.cloud.stream.binder.kafka.streams.KTableBoundElementFactory;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBinderMetrics;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsFunctionProcessor;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsMessageConversionDelegate;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsRegistry;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsStreamListenerSetupMethodOrchestrator;
import org.springframework.cloud.stream.binder.kafka.streams.KeyValueSerdeResolver;
import org.springframework.cloud.stream.binder.kafka.streams.SendToDlqAndContinue;
import org.springframework.cloud.stream.binder.kafka.streams.StreamsBuilderFactoryManager;
import org.springframework.cloud.stream.binder.kafka.streams.function.FunctionDetectorCondition;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.streams.serde.CompositeNonNativeSerde;
import org.springframework.cloud.stream.binder.kafka.streams.serde.MessageConverterDelegateSerde;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.StreamListenerResultAdapter;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.kafka.config.KafkaStreamsConfiguration;
import org.springframework.kafka.config.StreamsBuilderFactoryBeanCustomizer;
import org.springframework.kafka.core.CleanupConfig;
import org.springframework.kafka.streams.RecoveringDeserializationExceptionHandler;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={KafkaStreamsExtendedBindingProperties.class})
@ConditionalOnBean(value={BindingService.class})
@AutoConfigureAfter(value={BindingServiceConfiguration.class})
public class KafkaStreamsBinderSupportAutoConfiguration {
    private static final String KSTREAM_BINDER_TYPE = "kstream";
    private static final String KTABLE_BINDER_TYPE = "ktable";
    private static final String GLOBALKTABLE_BINDER_TYPE = "globalktable";

    @Bean
    @ConfigurationProperties(prefix="spring.cloud.stream.kafka.streams.binder")
    public KafkaStreamsBinderConfigurationProperties binderConfigurationProperties(KafkaProperties kafkaProperties, ConfigurableEnvironment environment, BindingServiceProperties properties) {
        Map<String, BinderConfiguration> binderConfigurations = KafkaStreamsBinderSupportAutoConfiguration.getBinderConfigurations(properties);
        for (Map.Entry<String, BinderConfiguration> entry : binderConfigurations.entrySet()) {
            BinderConfiguration binderConfiguration = entry.getValue();
            String binderType = binderConfiguration.getBinderType();
            if (binderType == null || !binderType.equals(KSTREAM_BINDER_TYPE) && !binderType.equals(KTABLE_BINDER_TYPE) && !binderType.equals(GLOBALKTABLE_BINDER_TYPE)) continue;
            HashMap<String, Object> binderProperties = new HashMap<String, Object>();
            this.flatten(null, binderConfiguration.getProperties(), binderProperties);
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("kafkaStreamsBinderEnv", binderProperties));
        }
        return new KafkaStreamsBinderConfigurationProperties(kafkaProperties);
    }

    private static Map<String, BinderConfiguration> getBinderConfigurations(BindingServiceProperties properties) {
        HashMap<String, BinderConfiguration> binderConfigurations = new HashMap<String, BinderConfiguration>();
        Map declaredBinders = properties.getBinders();
        for (Map.Entry binderEntry : declaredBinders.entrySet()) {
            BinderProperties binderProperties = (BinderProperties)binderEntry.getValue();
            binderConfigurations.put((String)binderEntry.getKey(), new BinderConfiguration(binderProperties.getType(), binderProperties.getEnvironment(), binderProperties.isInheritEnvironment(), binderProperties.isDefaultCandidate()));
        }
        return binderConfigurations;
    }

    private void flatten(String propertyName, Object value, Map<String, Object> flattenedProperties) {
        if (value instanceof Map) {
            ((Map)value).forEach((k, v) -> this.flatten((propertyName != null ? propertyName + "." : "") + k, v, flattenedProperties));
        } else {
            flattenedProperties.put(propertyName, value.toString());
        }
    }

    @Bean
    public KafkaStreamsConfiguration kafkaStreamsConfiguration(KafkaStreamsBinderConfigurationProperties properties, Environment environment) {
        String applicationName;
        KafkaProperties kafkaProperties = properties.getKafkaProperties();
        Map streamsProperties = kafkaProperties.buildStreamsProperties();
        if (kafkaProperties.getStreams().getApplicationId() == null && (applicationName = environment.getProperty("spring.application.name")) != null) {
            streamsProperties.put("application.id", applicationName);
        }
        return new KafkaStreamsConfiguration(streamsProperties);
    }

    @Bean(value={"streamConfigGlobalProperties"})
    public Map<String, Object> streamConfigGlobalProperties(KafkaStreamsBinderConfigurationProperties configProperties, KafkaStreamsConfiguration kafkaStreamsConfiguration, ConfigurableEnvironment environment, SendToDlqAndContinue sendToDlqAndContinue) {
        String kafkaBinderBroker;
        String kafkaStreamsBinderBroker;
        Properties properties = kafkaStreamsConfiguration.asProperties();
        String kafkaConnectionString = configProperties.getKafkaConnectionString();
        if (kafkaConnectionString != null && kafkaConnectionString.equals("localhost:9092") && StringUtils.isEmpty((Object)(kafkaStreamsBinderBroker = environment.getProperty("spring.cloud.stream.kafka.streams.binder.brokers"))) && !StringUtils.isEmpty((Object)(kafkaBinderBroker = environment.getProperty("spring.cloud.stream.kafka.binder.brokers")))) {
            kafkaConnectionString = kafkaBinderBroker;
            configProperties.setBrokers(new String[]{kafkaConnectionString});
        }
        if (ObjectUtils.isEmpty((Object)properties.get("bootstrap.servers"))) {
            properties.put("bootstrap.servers", kafkaConnectionString);
        } else {
            List bootStrapCollection;
            Object bootstrapServerConfig = properties.get("bootstrap.servers");
            if (bootstrapServerConfig instanceof String) {
                String bootStrapServers = (String)properties.get("bootstrap.servers");
                if (bootStrapServers.equals("localhost:9092")) {
                    properties.put("bootstrap.servers", kafkaConnectionString);
                }
            } else if (bootstrapServerConfig instanceof List && (bootStrapCollection = (List)bootstrapServerConfig).size() == 1 && bootStrapCollection.get(0).equals("localhost:9092")) {
                properties.put("bootstrap.servers", kafkaConnectionString);
            }
        }
        String binderProvidedApplicationId = configProperties.getApplicationId();
        if (StringUtils.hasText((String)binderProvidedApplicationId)) {
            properties.put("application.id", binderProvidedApplicationId);
        }
        properties.put("default.key.serde", Serdes.ByteArraySerde.class.getName());
        properties.put("default.value.serde", Serdes.ByteArraySerde.class.getName());
        if (configProperties.getDeserializationExceptionHandler() == DeserializationExceptionHandler.logAndContinue) {
            properties.put("default.deserialization.exception.handler", LogAndContinueExceptionHandler.class);
        } else if (configProperties.getDeserializationExceptionHandler() == DeserializationExceptionHandler.logAndFail) {
            properties.put("default.deserialization.exception.handler", LogAndFailExceptionHandler.class);
        } else if (configProperties.getDeserializationExceptionHandler() == DeserializationExceptionHandler.sendToDlq) {
            properties.put("default.deserialization.exception.handler", RecoveringDeserializationExceptionHandler.class);
            properties.put("spring.deserialization.recoverer", sendToDlqAndContinue);
        }
        if (!ObjectUtils.isEmpty((Object)configProperties.getConfiguration())) {
            properties.putAll((Map<?, ?>)configProperties.getConfiguration());
        }
        return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), Map.Entry::getValue));
    }

    @Bean
    public KStreamStreamListenerResultAdapter kstreamStreamListenerResultAdapter() {
        return new KStreamStreamListenerResultAdapter();
    }

    @Bean
    public KStreamStreamListenerParameterAdapter kstreamStreamListenerParameterAdapter(KafkaStreamsMessageConversionDelegate kstreamBoundMessageConversionDelegate, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2) {
        return new KStreamStreamListenerParameterAdapter(kstreamBoundMessageConversionDelegate, KafkaStreamsBindingInformationCatalogue2);
    }

    @Bean
    public KafkaStreamsStreamListenerSetupMethodOrchestrator kafkaStreamsStreamListenerSetupMethodOrchestrator(BindingServiceProperties bindingServiceProperties, KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties, KeyValueSerdeResolver keyValueSerdeResolver, KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue, KStreamStreamListenerParameterAdapter kafkaStreamListenerParameterAdapter, Collection<StreamListenerResultAdapter> streamListenerResultAdapters, ObjectProvider<CleanupConfig> cleanupConfig, ObjectProvider<StreamsBuilderFactoryBeanCustomizer> customizerProvider) {
        return new KafkaStreamsStreamListenerSetupMethodOrchestrator(bindingServiceProperties, kafkaStreamsExtendedBindingProperties, keyValueSerdeResolver, kafkaStreamsBindingInformationCatalogue, kafkaStreamListenerParameterAdapter, streamListenerResultAdapters, (CleanupConfig)cleanupConfig.getIfUnique(), (StreamsBuilderFactoryBeanCustomizer)customizerProvider.getIfUnique());
    }

    @Bean
    public KafkaStreamsMessageConversionDelegate messageConversionDelegate(@Qualifier(value="integrationArgumentResolverMessageConverter") CompositeMessageConverter compositeMessageConverter, SendToDlqAndContinue sendToDlqAndContinue, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2, KafkaStreamsBinderConfigurationProperties binderConfigurationProperties) {
        return new KafkaStreamsMessageConversionDelegate(compositeMessageConverter, sendToDlqAndContinue, KafkaStreamsBindingInformationCatalogue2, binderConfigurationProperties);
    }

    @Bean
    public MessageConverterDelegateSerde messageConverterDelegateSerde(@Qualifier(value="integrationArgumentResolverMessageConverter") CompositeMessageConverter compositeMessageConverterFactory) {
        return new MessageConverterDelegateSerde(compositeMessageConverterFactory);
    }

    @Bean
    public CompositeNonNativeSerde compositeNonNativeSerde(@Qualifier(value="integrationArgumentResolverMessageConverter") CompositeMessageConverter compositeMessageConverterFactory) {
        return new CompositeNonNativeSerde(compositeMessageConverterFactory);
    }

    @Bean
    public KStreamBoundElementFactory kStreamBoundElementFactory(BindingServiceProperties bindingServiceProperties, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2, EncodingDecodingBindAdviceHandler encodingDecodingBindAdviceHandler) {
        return new KStreamBoundElementFactory(bindingServiceProperties, KafkaStreamsBindingInformationCatalogue2, encodingDecodingBindAdviceHandler);
    }

    @Bean
    public KTableBoundElementFactory kTableBoundElementFactory(BindingServiceProperties bindingServiceProperties, EncodingDecodingBindAdviceHandler encodingDecodingBindAdviceHandler) {
        return new KTableBoundElementFactory(bindingServiceProperties, encodingDecodingBindAdviceHandler);
    }

    @Bean
    public GlobalKTableBoundElementFactory globalKTableBoundElementFactory(BindingServiceProperties properties, EncodingDecodingBindAdviceHandler encodingDecodingBindAdviceHandler) {
        return new GlobalKTableBoundElementFactory(properties, encodingDecodingBindAdviceHandler);
    }

    @Bean
    public SendToDlqAndContinue sendToDlqAndContinue() {
        return new SendToDlqAndContinue();
    }

    @Bean
    public KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue() {
        return new KafkaStreamsBindingInformationCatalogue();
    }

    @Bean
    @ConditionalOnMissingBean
    public KeyValueSerdeResolver keyValueSerdeResolver(@Qualifier(value="streamConfigGlobalProperties") Object streamConfigGlobalProperties, KafkaStreamsBinderConfigurationProperties properties) {
        return new KeyValueSerdeResolver((Map)streamConfigGlobalProperties, properties);
    }

    @Bean
    public InteractiveQueryService interactiveQueryServices(KafkaStreamsRegistry kafkaStreamsRegistry, KafkaStreamsBinderConfigurationProperties properties) {
        return new InteractiveQueryService(kafkaStreamsRegistry, properties);
    }

    @Bean
    public KafkaStreamsRegistry kafkaStreamsRegistry() {
        return new KafkaStreamsRegistry();
    }

    @Bean
    public StreamsBuilderFactoryManager streamsBuilderFactoryManager(KafkaStreamsBindingInformationCatalogue catalogue, KafkaStreamsRegistry kafkaStreamsRegistry, @Nullable KafkaStreamsBinderMetrics kafkaStreamsBinderMetrics) {
        return new StreamsBuilderFactoryManager(catalogue, kafkaStreamsRegistry, kafkaStreamsBinderMetrics);
    }

    @Bean
    @Conditional(value={FunctionDetectorCondition.class})
    public KafkaStreamsFunctionProcessor kafkaStreamsFunctionProcessor(BindingServiceProperties bindingServiceProperties, KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties, KeyValueSerdeResolver keyValueSerdeResolver, KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue, KafkaStreamsMessageConversionDelegate kafkaStreamsMessageConversionDelegate, ObjectProvider<CleanupConfig> cleanupConfig, StreamFunctionProperties streamFunctionProperties, KafkaStreamsBinderConfigurationProperties kafkaStreamsBinderConfigurationProperties, ObjectProvider<StreamsBuilderFactoryBeanCustomizer> customizerProvider) {
        return new KafkaStreamsFunctionProcessor(bindingServiceProperties, kafkaStreamsExtendedBindingProperties, keyValueSerdeResolver, kafkaStreamsBindingInformationCatalogue, kafkaStreamsMessageConversionDelegate, (CleanupConfig)cleanupConfig.getIfUnique(), streamFunctionProperties, kafkaStreamsBinderConfigurationProperties, (StreamsBuilderFactoryBeanCustomizer)customizerProvider.getIfUnique());
    }

    @Bean
    public EncodingDecodingBindAdviceHandler encodingDecodingBindAdviceHandler() {
        return new EncodingDecodingBindAdviceHandler();
    }

    @Configuration
    @ConditionalOnBean(name={"outerContext"})
    @ConditionalOnMissingBean(value={KafkaStreamsBinderMetrics.class})
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    protected class KafkaStreamsBinderMetricsConfigurationWithMultiBinder {
        protected KafkaStreamsBinderMetricsConfigurationWithMultiBinder() {
        }

        @Bean
        public KafkaStreamsBinderMetrics kafkaStreamsBinderMetrics(ConfigurableApplicationContext context) {
            MeterRegistry meterRegistry = (MeterRegistry)((ApplicationContext)context.getBean("outerContext", ApplicationContext.class)).getBean(MeterRegistry.class);
            return new KafkaStreamsBinderMetrics(meterRegistry);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={KafkaStreamsBinderMetrics.class}, name={"outerContext"})
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    protected class KafkaStreamsBinderMetricsConfiguration {
        protected KafkaStreamsBinderMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={MeterRegistry.class})
        @ConditionalOnMissingBean(value={KafkaStreamsBinderMetrics.class})
        public KafkaStreamsBinderMetrics kafkaStreamsBinderMetrics(MeterRegistry meterRegistry) {
            return new KafkaStreamsBinderMetrics(meterRegistry);
        }
    }
}

