/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.function;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;

public class FunctionDetectorCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        if (context != null && context.getBeanFactory() != null) {
            Map functionTypes = context.getBeanFactory().getBeansOfType(Function.class);
            functionTypes.putAll(context.getBeanFactory().getBeansOfType(Consumer.class));
            Map kstreamFunctions = FunctionDetectorCondition.pruneFunctionBeansForKafkaStreams(functionTypes, context);
            if (!kstreamFunctions.isEmpty()) {
                return ConditionOutcome.match((String)"Matched. Function/Consumer beans found");
            }
            return ConditionOutcome.noMatch((String)"No match. No Function/Consumer beans found");
        }
        return ConditionOutcome.noMatch((String)"No match. No Function/Consumer beans found");
    }

    private static <T> Map<String, T> pruneFunctionBeansForKafkaStreams(Map<String, T> originalFunctionBeans, ConditionContext context) {
        HashMap<String, T> prunedMap = new HashMap<String, T>();
        for (String key : originalFunctionBeans.keySet()) {
            Class classObj = ClassUtils.resolveClassName((String)((AnnotatedBeanDefinition)context.getBeanFactory().getBeanDefinition(key)).getMetadata().getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
            try {
                Method method = classObj.getMethod(key, new Class[0]);
                ResolvableType resolvableType = ResolvableType.forMethodReturnType((Method)method, (Class)classObj);
                Class rawClass = resolvableType.getGeneric(new int[]{0}).getRawClass();
                if (rawClass != KStream.class && rawClass != KTable.class && rawClass != GlobalKTable.class) continue;
                prunedMap.put(key, originalFunctionBeans.get(key));
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return prunedMap;
    }
}

