/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.function;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;

class KafkaStreamsFunctionBeanPostProcessor
implements InitializingBean,
BeanFactoryAware {
    private ConfigurableListableBeanFactory beanFactory;
    private Map<String, ResolvableType> resolvableTypeMap = new TreeMap<String, ResolvableType>();

    KafkaStreamsFunctionBeanPostProcessor() {
    }

    public Map<String, ResolvableType> getResolvableTypes() {
        return this.resolvableTypeMap;
    }

    public void afterPropertiesSet() {
        String[] functionNames = this.beanFactory.getBeanNamesForType(Function.class);
        String[] consumerNames = this.beanFactory.getBeanNamesForType(Consumer.class);
        Stream.concat(Stream.of(functionNames), Stream.of(consumerNames)).forEach(this::extractResolvableTypes);
    }

    private void extractResolvableTypes(String key) {
        Class classObj = ClassUtils.resolveClassName((String)((AnnotatedBeanDefinition)this.beanFactory.getBeanDefinition(key)).getMetadata().getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
        try {
            Method method = classObj.getMethod(key, new Class[0]);
            ResolvableType resolvableType = ResolvableType.forMethodReturnType((Method)method, (Class)classObj);
            this.resolvableTypeMap.put(key, resolvableType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }
}

