/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaProducerProperties;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.ObjectUtils;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

class KafkaStreamsDlqDispatch {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final KafkaTemplate<byte[], byte[]> kafkaTemplate;
    private final String dlqName;

    KafkaStreamsDlqDispatch(String dlqName, KafkaBinderConfigurationProperties kafkaBinderConfigurationProperties, KafkaConsumerProperties kafkaConsumerProperties) {
        DefaultKafkaProducerFactory<byte[], byte[]> producerFactory = this.getProducerFactory((ExtendedProducerProperties<KafkaProducerProperties>)new ExtendedProducerProperties((Object)kafkaConsumerProperties.getDlqProducerProperties()), kafkaBinderConfigurationProperties);
        this.kafkaTemplate = new KafkaTemplate(producerFactory);
        this.dlqName = dlqName;
    }

    public void sendToDlq(byte[] key, byte[] value, int partittion) {
        block2: {
            ProducerRecord producerRecord = new ProducerRecord(this.dlqName, Integer.valueOf(partittion), (Object)key, (Object)value, null);
            final StringBuilder sb = new StringBuilder().append(" a message with key='").append(this.toDisplayString(ObjectUtils.nullSafeToString((byte[])key))).append("'").append(" and payload='").append(this.toDisplayString(ObjectUtils.nullSafeToString((byte[])value))).append("'").append(" received from ").append(partittion);
            ListenableFuture sentDlq = null;
            try {
                sentDlq = this.kafkaTemplate.send(producerRecord);
                sentDlq.addCallback((ListenableFutureCallback)new ListenableFutureCallback<SendResult<byte[], byte[]>>(){

                    public void onFailure(Throwable ex) {
                        KafkaStreamsDlqDispatch.this.logger.error((Object)("Error sending to DLQ " + sb.toString()), ex);
                    }

                    public void onSuccess(SendResult<byte[], byte[]> result) {
                        if (KafkaStreamsDlqDispatch.this.logger.isDebugEnabled()) {
                            KafkaStreamsDlqDispatch.this.logger.debug((Object)("Sent to DLQ " + sb.toString()));
                        }
                    }
                });
            }
            catch (Exception ex) {
                if (sentDlq != null) break block2;
                this.logger.error((Object)("Error sending to DLQ " + sb.toString()), (Throwable)ex);
            }
        }
    }

    private DefaultKafkaProducerFactory<byte[], byte[]> getProducerFactory(ExtendedProducerProperties<KafkaProducerProperties> producerProperties, KafkaBinderConfigurationProperties configurationProperties) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("retries", 0);
        props.put("buffer.memory", 0x2000000);
        props.put("acks", configurationProperties.getRequiredAcks());
        Map mergedConfig = configurationProperties.mergedProducerConfiguration();
        if (!ObjectUtils.isEmpty((Object)mergedConfig)) {
            props.putAll(mergedConfig);
        }
        if (ObjectUtils.isEmpty(props.get("bootstrap.servers"))) {
            props.put("bootstrap.servers", configurationProperties.getKafkaConnectionString());
        }
        if (ObjectUtils.isEmpty(props.get("batch.size"))) {
            props.put("batch.size", String.valueOf(((KafkaProducerProperties)producerProperties.getExtension()).getBufferSize()));
        }
        if (ObjectUtils.isEmpty(props.get("linger.ms"))) {
            props.put("linger.ms", String.valueOf(((KafkaProducerProperties)producerProperties.getExtension()).getBatchTimeout()));
        }
        if (ObjectUtils.isEmpty(props.get("compression.type"))) {
            props.put("compression.type", ((KafkaProducerProperties)producerProperties.getExtension()).getCompressionType().toString());
        }
        if (!ObjectUtils.isEmpty((Object)((KafkaProducerProperties)producerProperties.getExtension()).getConfiguration())) {
            props.putAll(((KafkaProducerProperties)producerProperties.getExtension()).getConfiguration());
        }
        props.put("key.serializer", ByteArraySerializer.class);
        props.put("value.serializer", ByteArraySerializer.class);
        return new DefaultKafkaProducerFactory(props);
    }

    private String toDisplayString(String original) {
        if (original.length() <= 50) {
            return original;
        }
        return original.substring(0, 50) + "...";
    }
}

