/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsDlqDispatch;
import org.springframework.util.ReflectionUtils;

public class SendToDlqAndContinue
implements DeserializationExceptionHandler {
    private Map<String, KafkaStreamsDlqDispatch> dlqDispatchers = new HashMap<String, KafkaStreamsDlqDispatch>();

    public void sendToDlq(String topic, byte[] key, byte[] value, int partition) {
        KafkaStreamsDlqDispatch kafkaStreamsDlqDispatch = this.dlqDispatchers.get(topic);
        kafkaStreamsDlqDispatch.sendToDlq(key, value, partition);
    }

    public DeserializationExceptionHandler.DeserializationHandlerResponse handle(ProcessorContext context, ConsumerRecord<byte[], byte[]> record, Exception exception) {
        KafkaStreamsDlqDispatch kafkaStreamsDlqDispatch = this.dlqDispatchers.get(record.topic());
        kafkaStreamsDlqDispatch.sendToDlq((byte[])record.key(), (byte[])record.value(), record.partition());
        context.commit();
        if (context instanceof ProcessorContextImpl) {
            ProcessorContextImpl processorContextImpl = (ProcessorContextImpl)context;
            Field task = ReflectionUtils.findField(ProcessorContextImpl.class, (String)"task");
            ReflectionUtils.makeAccessible((Field)task);
            Object taskField = ReflectionUtils.getField((Field)task, (Object)processorContextImpl);
            if (taskField.getClass().isAssignableFrom(StreamTask.class)) {
                StreamTask streamTask = (StreamTask)taskField;
                Field consumer = ReflectionUtils.findField(StreamTask.class, (String)"consumer");
                ReflectionUtils.makeAccessible((Field)consumer);
                Object kafkaConsumerField = ReflectionUtils.getField((Field)consumer, (Object)streamTask);
                if (kafkaConsumerField.getClass().isAssignableFrom(KafkaConsumer.class)) {
                    KafkaConsumer kafkaConsumer = (KafkaConsumer)kafkaConsumerField;
                    HashMap<TopicPartition, OffsetAndMetadata> consumedOffsetsAndMetadata = new HashMap<TopicPartition, OffsetAndMetadata>();
                    TopicPartition tp = new TopicPartition(record.topic(), record.partition());
                    OffsetAndMetadata oam = new OffsetAndMetadata(record.offset() + 1L);
                    consumedOffsetsAndMetadata.put(tp, oam);
                    kafkaConsumer.commitSync(consumedOffsetsAndMetadata);
                }
            }
        }
        return DeserializationExceptionHandler.DeserializationHandlerResponse.CONTINUE;
    }

    public void configure(Map<String, ?> configs) {
    }

    void addKStreamDlqDispatch(String topic, KafkaStreamsDlqDispatch kafkaStreamsDlqDispatch) {
        this.dlqDispatchers.put(topic, kafkaStreamsDlqDispatch);
    }
}

