/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.kstream.KTable;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.DefaultBinding;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsDlqDispatch;
import org.springframework.cloud.stream.binder.kafka.streams.SendToDlqAndContinue;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsProducerProperties;
import org.springframework.util.StringUtils;

class KTableBinder
extends AbstractBinder<KTable<Object, Object>, ExtendedConsumerProperties<KafkaStreamsConsumerProperties>, ExtendedProducerProperties<KafkaStreamsProducerProperties>>
implements ExtendedPropertiesBinder<KTable<Object, Object>, KafkaStreamsConsumerProperties, KafkaStreamsProducerProperties> {
    private final KafkaStreamsBinderConfigurationProperties binderConfigurationProperties;
    private final KafkaTopicProvisioner kafkaTopicProvisioner;
    private final KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue;
    private KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties = new KafkaStreamsExtendedBindingProperties();

    KTableBinder(KafkaStreamsBinderConfigurationProperties binderConfigurationProperties, KafkaTopicProvisioner kafkaTopicProvisioner, KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue) {
        this.binderConfigurationProperties = binderConfigurationProperties;
        this.kafkaTopicProvisioner = kafkaTopicProvisioner;
        this.KafkaStreamsBindingInformationCatalogue = kafkaStreamsBindingInformationCatalogue;
    }

    protected Binding<KTable<Object, Object>> doBindConsumer(String name, String group, KTable<Object, Object> inputTarget, ExtendedConsumerProperties<KafkaStreamsConsumerProperties> properties) {
        ExtendedConsumerProperties extendedConsumerProperties = new ExtendedConsumerProperties(properties.getExtension());
        if (this.binderConfigurationProperties.getSerdeError() == KafkaStreamsBinderConfigurationProperties.SerdeError.sendToDlq) {
            ((KafkaConsumerProperties)extendedConsumerProperties.getExtension()).setEnableDlq(true);
        }
        if (!StringUtils.hasText((String)group)) {
            group = this.binderConfigurationProperties.getApplicationId();
        }
        this.kafkaTopicProvisioner.provisionConsumerDestination(name, group, extendedConsumerProperties);
        if (((KafkaConsumerProperties)extendedConsumerProperties.getExtension()).isEnableDlq()) {
            String dlqName = StringUtils.isEmpty((Object)((KafkaConsumerProperties)extendedConsumerProperties.getExtension()).getDlqName()) ? "error." + name + "." + group : ((KafkaConsumerProperties)extendedConsumerProperties.getExtension()).getDlqName();
            KafkaStreamsDlqDispatch kafkaStreamsDlqDispatch = new KafkaStreamsDlqDispatch(dlqName, this.binderConfigurationProperties, (KafkaConsumerProperties)extendedConsumerProperties.getExtension());
            SendToDlqAndContinue sendToDlqAndContinue = (SendToDlqAndContinue)this.getApplicationContext().getBean(SendToDlqAndContinue.class);
            sendToDlqAndContinue.addKStreamDlqDispatch(name, kafkaStreamsDlqDispatch);
            StreamsConfig streamsConfig = this.KafkaStreamsBindingInformationCatalogue.getStreamsConfig(inputTarget);
            DeserializationExceptionHandler deserializationExceptionHandler = streamsConfig.defaultDeserializationExceptionHandler();
            if (deserializationExceptionHandler instanceof SendToDlqAndContinue) {
                ((SendToDlqAndContinue)deserializationExceptionHandler).addKStreamDlqDispatch(name, kafkaStreamsDlqDispatch);
            }
        }
        return new DefaultBinding(name, group, inputTarget, null);
    }

    protected Binding<KTable<Object, Object>> doBindProducer(String name, KTable<Object, Object> outboundBindTarget, ExtendedProducerProperties<KafkaStreamsProducerProperties> properties) {
        throw new UnsupportedOperationException("No producer level binding is allowed for KTable");
    }

    public KafkaStreamsConsumerProperties getExtendedConsumerProperties(String channelName) {
        return this.kafkaStreamsExtendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public KafkaStreamsProducerProperties getExtendedProducerProperties(String channelName) {
        return this.kafkaStreamsExtendedBindingProperties.getExtendedProducerProperties(channelName);
    }
}

