/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.binder.kafka.streams.KStreamBinder;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsMessageConversionDelegate;
import org.springframework.cloud.stream.binder.kafka.streams.KeyValueSerdeResolver;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsExtendedBindingProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class KStreamBinderConfiguration {
    private static final Log logger = LogFactory.getLog(KStreamBinderConfiguration.class);
    @Autowired
    private KafkaProperties kafkaProperties;
    @Autowired
    private KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties;

    @Bean
    public KafkaTopicProvisioner provisioningProvider(KafkaBinderConfigurationProperties binderConfigurationProperties) {
        return new KafkaTopicProvisioner(binderConfigurationProperties, this.kafkaProperties);
    }

    @Bean
    public KStreamBinder kStreamBinder(KafkaStreamsBinderConfigurationProperties binderConfigurationProperties, KafkaTopicProvisioner kafkaTopicProvisioner, KafkaStreamsMessageConversionDelegate KafkaStreamsMessageConversionDelegate2, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2, KeyValueSerdeResolver keyValueSerdeResolver) {
        KStreamBinder kStreamBinder = new KStreamBinder(binderConfigurationProperties, kafkaTopicProvisioner, KafkaStreamsMessageConversionDelegate2, KafkaStreamsBindingInformationCatalogue2, keyValueSerdeResolver);
        kStreamBinder.setKafkaStreamsExtendedBindingProperties(this.kafkaStreamsExtendedBindingProperties);
        return kStreamBinder;
    }
}

