/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure.flatfile;

import java.util.ArrayList;
import java.util.Map;
import org.springframework.batch.item.file.FlatFileFooterCallback;
import org.springframework.batch.item.file.FlatFileHeaderCallback;
import org.springframework.batch.item.file.FlatFileItemWriter;
import org.springframework.batch.item.file.builder.FlatFileItemWriterBuilder;
import org.springframework.batch.item.file.transform.FieldExtractor;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.batch.autoconfigure.flatfile.FlatFileItemWriterProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.WritableResource;

@AutoConfiguration
@EnableConfigurationProperties(value={FlatFileItemWriterProperties.class})
@AutoConfigureAfter(value={BatchAutoConfiguration.class})
public class FlatFileItemWriterAutoConfiguration {
    private FlatFileItemWriterProperties properties;
    @Autowired(required=false)
    private LineAggregator<Map<String, Object>> lineAggregator;
    @Autowired(required=false)
    private FieldExtractor<Map<String, Object>> fieldExtractor;
    @Autowired(required=false)
    private FlatFileHeaderCallback headerCallback;
    @Autowired(required=false)
    private FlatFileFooterCallback footerCallback;

    public FlatFileItemWriterAutoConfiguration(FlatFileItemWriterProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.batch.job.flatfileitemwriter", name={"name"})
    public FlatFileItemWriter<Map<String, Object>> itemWriter() {
        if (this.properties.isDelimited() && this.properties.isFormatted()) {
            throw new IllegalStateException("An output file must be either delimited or formatted or a custom LineAggregator must be provided. Your current configuration specifies both delimited and formatted");
        }
        if ((this.properties.isFormatted() || this.properties.isDelimited()) && this.lineAggregator != null) {
            throw new IllegalStateException("A LineAggregator must be configured if the output is not formatted or delimited");
        }
        FlatFileItemWriterBuilder builder = new FlatFileItemWriterBuilder().name(this.properties.getName()).resource((WritableResource)this.properties.getResource()).append(this.properties.isAppend()).encoding(this.properties.getEncoding()).forceSync(this.properties.isForceSync()).lineSeparator(this.properties.getLineSeparator()).saveState(this.properties.isSaveState()).shouldDeleteIfEmpty(this.properties.isShouldDeleteIfEmpty()).shouldDeleteIfExists(this.properties.isShouldDeleteIfExists()).transactional(this.properties.isTransactional()).headerCallback(this.headerCallback).footerCallback(this.footerCallback);
        if (this.properties.isDelimited()) {
            FlatFileItemWriterBuilder.DelimitedBuilder delimitedBuilder = builder.delimited().delimiter(this.properties.getDelimiter());
            if (this.fieldExtractor != null) {
                delimitedBuilder.fieldExtractor(this.fieldExtractor);
            } else {
                delimitedBuilder.fieldExtractor((FieldExtractor)new MapFieldExtractor(this.properties.getNames()));
            }
        } else if (this.properties.isFormatted()) {
            FlatFileItemWriterBuilder.FormattedBuilder formattedBuilder = builder.formatted().format(this.properties.getFormat()).locale(this.properties.getLocale()).maximumLength(this.properties.getMaximumLength()).minimumLength(this.properties.getMinimumLength());
            if (this.fieldExtractor != null) {
                formattedBuilder.fieldExtractor(this.fieldExtractor);
            } else {
                formattedBuilder.fieldExtractor((FieldExtractor)new MapFieldExtractor(this.properties.getNames()));
            }
        } else if (this.lineAggregator != null) {
            builder.lineAggregator(this.lineAggregator);
        }
        return builder.build();
    }

    public static class MapFieldExtractor
    implements FieldExtractor<Map<String, Object>> {
        private String[] names;

        public MapFieldExtractor(String[] names) {
            this.names = names;
        }

        public Object[] extract(Map<String, Object> item) {
            ArrayList<Object> fields = new ArrayList<Object>(item.size());
            for (String name : this.names) {
                fields.add(item.get(name));
            }
            return fields.toArray();
        }
    }
}

