/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor.sample;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.test.system.CapturedOutput;
import org.springframework.boot.test.system.OutputCaptureExtension;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.Issue866Configuration;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.TraceReactorAutoConfigurationAccessorConfiguration;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.instrument.reactor.sample.FactoryUser;
import org.springframework.cloud.sleuth.instrument.reactor.sample.ManualRequestSender;
import org.springframework.cloud.sleuth.instrument.reactor.sample.RequestSender;
import org.springframework.cloud.sleuth.instrument.reactor.sample.SpanProvider;
import org.springframework.cloud.sleuth.instrument.web.WebFluxSleuthOperators;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

@ExtendWith(value={OutputCaptureExtension.class})
public abstract class FlatMapTests {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlatMapTests.class);

    @BeforeAll
    public static void setup() {
        TraceReactorAutoConfigurationAccessorConfiguration.close();
        Issue866Configuration.hook = null;
    }

    @AfterAll
    public static void cleanup() {
        Issue866Configuration.hook = null;
    }

    @Test
    public void should_work_with_flat_maps_with_on_queues_instrumentation(CapturedOutput capture) {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class, this.testConfiguration(), Issue866Configuration.class}).web(WebApplicationType.REACTIVE).properties(new String[]{"server.port=0", "spring.jmx.enabled=false", "spring.sleuth.reactor.instrumentation-type=DECORATE_QUEUES", "spring.application.name=TraceWebFluxOnQueuesTests", "security.basic.enabled=false", "management.security.enabled=false"}).run(new String[0]);
        this.assertReactorTracing(context, capture, () -> ((TestConfiguration)context.getBean(TestConfiguration.class)).spanInFoo);
    }

    protected abstract Class testConfiguration();

    @Test
    public void should_work_with_flat_maps_with_on_last_operator_instrumentation(CapturedOutput capture) {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class, this.testConfiguration(), Issue866Configuration.class}).web(WebApplicationType.REACTIVE).properties(new String[]{"server.port=0", "spring.jmx.enabled=false", "spring.sleuth.reactor.instrumentation-type=DECORATE_ON_LAST", "spring.application.name=TraceWebFluxOnLastTests", "security.basic.enabled=false", "management.security.enabled=false"}).run(new String[0]);
        this.assertReactorTracing(context, capture, () -> ((TestConfiguration)context.getBean(TestConfiguration.class)).spanInFoo);
    }

    @Test
    public void should_work_with_flat_maps_with_on_each_operator_instrumentation(CapturedOutput capture) {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class, this.testConfiguration(), Issue866Configuration.class}).web(WebApplicationType.REACTIVE).properties(new String[]{"server.port=0", "spring.jmx.enabled=false", "spring.sleuth.reactor.instrumentation-type=DECORATE_ON_EACH", "spring.application.name=TraceWebFluxOnEachTests", "security.basic.enabled=false", "management.security.enabled=false"}).run(new String[0]);
        this.assertReactorTracing(context, capture, () -> ((TestConfiguration)context.getBean(TestConfiguration.class)).spanInFoo);
    }

    @Test
    public void should_work_with_flat_maps_with_on_manual_operator_instrumentation(CapturedOutput capture) {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{TestManualConfiguration.class, this.testConfiguration(), Issue866Configuration.class}).web(WebApplicationType.REACTIVE).properties(new String[]{"server.port=0", "spring.jmx.enabled=false", "spring.sleuth.reactor.instrumentation-type=MANUAL", "spring.application.name=TraceWebFluxOnManualTests", "security.basic.enabled=false", "management.security.enabled=false"}).run(new String[0]);
        this.assertReactorTracing(context, capture, () -> ((TestManualConfiguration)context.getBean(TestManualConfiguration.class)).spanInFoo);
    }

    private void assertReactorTracing(ConfigurableApplicationContext context, CapturedOutput capture, SpanProvider spanProvider) {
        TestSpanHandler spans = (TestSpanHandler)context.getBean(TestSpanHandler.class);
        int port = (Integer)((Environment)context.getBean(Environment.class)).getProperty("local.server.port", Integer.class);
        RequestSender sender = (RequestSender)context.getBean(RequestSender.class);
        FactoryUser factoryUser = (FactoryUser)context.getBean(FactoryUser.class);
        sender.port = port;
        spans.clear();
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            LOGGER.info("Start");
            spans.clear();
            String firstTraceId = this.flatMapTraceId(spans, (ClientResponse)this.callFlatMap(port).block());
            LOGGER.info("Checking first trace id");
            this.thenAllWebClientCallsHaveSameTraceId(firstTraceId, sender);
            this.thenSpanInFooHasSameTraceId(firstTraceId, spanProvider);
            spans.clear();
            LOGGER.info("All web client calls have same trace id");
            LOGGER.info("Second trace start");
            String secondTraceId = this.flatMapTraceId(spans, (ClientResponse)this.callFlatMap(port).block());
            ((AbstractStringAssert)BDDAssertions.then((String)firstTraceId).as("Id will not be reused between calls", new Object[0])).isNotEqualTo((Object)secondTraceId);
            LOGGER.info("Id was not reused between calls");
            this.thenSpanInFooHasSameTraceId(secondTraceId, spanProvider);
            LOGGER.info("Span in Foo has same trace id");
            List requestUri = Arrays.stream(capture.toString().split("\n")).filter(s -> s.contains("Received a request to uri")).map(s -> s.split(",")[1]).collect(Collectors.toList());
            LOGGER.info("TracingFilter should not have any trace when receiving a request " + requestUri);
            ((ListAssert)BDDAssertions.then(requestUri).as("TracingFilter should not have any trace when receiving a request", new Object[0])).containsOnly((Object[])new String[]{""});
            BDDAssertions.then((boolean)factoryUser.wasSchedulerWrapped).isTrue();
            LOGGER.info("Factory was wrapped");
        });
    }

    private void thenAllWebClientCallsHaveSameTraceId(String traceId, RequestSender sender) {
        BDDAssertions.then((String)sender.span.context().traceId()).isEqualTo(traceId);
    }

    private void thenSpanInFooHasSameTraceId(String traceId, SpanProvider spanProvider) {
        BDDAssertions.then((String)((Span)spanProvider.get()).context().traceId()).isEqualTo(traceId);
    }

    private Mono<ClientResponse> callFlatMap(int port) {
        return WebClient.create().get().uri("http://localhost:" + port + "/withFlatMap", new Object[0]).exchange();
    }

    private String flatMapTraceId(TestSpanHandler spans, ClientResponse response) {
        BDDAssertions.then((int)response.statusCode().value()).isEqualTo(200);
        BDDAssertions.then((Iterable)spans).isNotEmpty();
        LOGGER.info("Accumulated spans: " + spans);
        List traceIdOfFlatMap = spans.reportedSpans().stream().filter(span -> span.getTags().containsKey("http.path") && ((String)span.getTags().get("http.path")).equals("/withFlatMap")).map(FinishedSpan::getTraceId).collect(Collectors.toList());
        BDDAssertions.then(traceIdOfFlatMap).hasSize(1);
        return (String)traceIdOfFlatMap.get(0);
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    static class TestManualConfiguration {
        Span spanInFoo;

        TestManualConfiguration() {
        }

        @Bean
        RouterFunction<ServerResponse> handlers(Tracer tracing, CurrentTraceContext currentTraceContext, ManualRequestSender requestSender) {
            return RouterFunctions.route((RequestPredicate)RequestPredicates.GET((String)"/noFlatMap"), request -> {
                ServerWebExchange exchange = request.exchange();
                WebFluxSleuthOperators.withSpanInScope((Tracer)tracing, (CurrentTraceContext)currentTraceContext, (ServerWebExchange)exchange, () -> LOGGER.info("noFlatMap"));
                Flux one = requestSender.getAll().map(String::length);
                return ServerResponse.ok().body((Publisher)one, Integer.class);
            }).andRoute(RequestPredicates.GET((String)"/withFlatMap"), request -> {
                ServerWebExchange exchange = request.exchange();
                WebFluxSleuthOperators.withSpanInScope((Tracer)tracing, (CurrentTraceContext)currentTraceContext, (ServerWebExchange)exchange, () -> LOGGER.info("withFlatMap"));
                Flux one = requestSender.getAll().map(String::length);
                Flux response = one.flatMap(size -> requestSender.getAll().doOnEach(sig -> WebFluxSleuthOperators.withSpanInScope((Context)sig.getContext(), () -> LOGGER.info(sig.getContext().toString())))).map(string -> {
                    WebFluxSleuthOperators.withSpanInScope((Tracer)tracing, (CurrentTraceContext)currentTraceContext, (ServerWebExchange)exchange, () -> LOGGER.info("WHATEVER YEAH"));
                    return string.length();
                });
                return ServerResponse.ok().body((Publisher)response, Integer.class);
            }).andRoute(RequestPredicates.GET((String)"/foo"), request -> {
                ServerWebExchange exchange = request.exchange();
                WebFluxSleuthOperators.withSpanInScope((Tracer)tracing, (CurrentTraceContext)currentTraceContext, (ServerWebExchange)exchange, () -> {
                    LOGGER.info("foo");
                    this.spanInFoo = tracing.currentSpan();
                });
                return ServerResponse.ok().body((Publisher)Flux.just((Object)1), Integer.class);
            });
        }

        @Bean
        WebClient webClient() {
            return WebClient.create();
        }

        @Bean
        ManualRequestSender sender(WebClient client, Tracer tracer) {
            return new ManualRequestSender(client, tracer);
        }

        @Bean
        FactoryUser factoryUser() {
            return new FactoryUser();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    static class TestConfiguration {
        Span spanInFoo;

        TestConfiguration() {
        }

        @Bean
        RouterFunction<ServerResponse> handlers(Tracer tracer, RequestSender requestSender) {
            return RouterFunctions.route((RequestPredicate)RequestPredicates.GET((String)"/noFlatMap"), request -> {
                LOGGER.info("noFlatMap");
                Flux one = requestSender.getAll().map(String::length);
                return ServerResponse.ok().body((Publisher)one, Integer.class);
            }).andRoute(RequestPredicates.GET((String)"/withFlatMap"), request -> {
                LOGGER.info("withFlatMap");
                Flux one = requestSender.getAll().map(String::length);
                Flux response = one.flatMap(size -> requestSender.getAll().doOnEach(sig -> LOGGER.info(sig.getContext().toString()))).map(string -> {
                    LOGGER.info("WHATEVER YEAH");
                    return string.length();
                });
                return ServerResponse.ok().body((Publisher)response, Integer.class);
            }).andRoute(RequestPredicates.GET((String)"/foo"), request -> {
                LOGGER.info("foo");
                this.spanInFoo = tracer.currentSpan();
                return ServerResponse.ok().body((Publisher)Flux.just((Object)1), Integer.class);
            });
        }

        @Bean
        WebClient webClient() {
            return WebClient.create();
        }

        @Bean
        RequestSender sender(WebClient client, Tracer tracer) {
            return new RequestSender(client, tracer);
        }

        @Bean
        FactoryUser factoryUser() {
            return new FactoryUser();
        }
    }
}

