/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.instrument.async.TraceAsyncAspect;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;

public abstract class TraceAsyncAspectTest
implements TestTracingAwareSupplier {
    ProceedingJoinPoint point = (ProceedingJoinPoint)Mockito.mock(ProceedingJoinPoint.class);

    @BeforeEach
    public void setup() throws NoSuchMethodException {
        MethodSignature signature = (MethodSignature)Mockito.mock(MethodSignature.class);
        BDDMockito.given((Object)signature.getName()).willReturn((Object)"fooBar");
        BDDMockito.given((Object)signature.getMethod()).willReturn((Object)TraceAsyncAspectTest.class.getMethod("setup", new Class[0]));
        BDDMockito.given((Object)this.point.getSignature()).willReturn((Object)signature);
        BDDMockito.given((Object)this.point.getTarget()).willReturn((Object)"");
    }

    @Test
    public void should_work() throws Throwable {
        TraceAsyncAspect asyncAspect = new TraceAsyncAspect(this.tracerTest().tracing().tracer(), (SpanNamer)new DefaultSpanNamer()){

            String name(ProceedingJoinPoint pjp) {
                return "foo-bar";
            }
        };
        asyncAspect.traceBackgroundThread(this.point);
        BDDAssertions.then(this.tracerTest().handler().reportedSpans()).hasSize(1);
        BDDAssertions.then((String)this.tracerTest().handler().reportedSpans().get(0).getName()).isEqualTo("foo-bar");
        BDDAssertions.then((long)this.tracerTest().handler().reportedSpans().get(0).getEndTimestamp()).isPositive();
    }
}

