/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.baggage.multiple;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.BaggageInScope;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.baggage.multiple.Greeting;
import org.springframework.cloud.sleuth.baggage.multiple.Sender;
import org.springframework.http.HttpHeaders;
import org.springframework.integration.annotation.Aggregator;
import org.springframework.integration.annotation.IntegrationComponentScan;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.annotation.Splitter;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MessageEndpoint
@IntegrationComponentScan
public class DemoApplication {
    private static final Log log = LogFactory.getLog(DemoApplication.class);
    Span httpSpan;
    Span splitterSpan;
    Span aggregatorSpan;
    Span serviceActivatorSpan;
    @Autowired
    Sender sender;
    @Autowired
    Tracer tracer;
    String baggageValue;

    @RequestMapping(value={"/greeting"})
    public Greeting greeting(@RequestParam(defaultValue="Hello World!") String message, @RequestHeader HttpHeaders headers) {
        this.sender.send(message);
        this.httpSpan = this.tracer.currentSpan();
        try (BaggageInScope baggageInScope = this.tracer.getBaggage("country-code");){
            String baggage;
            if (baggageInScope != null && (baggage = baggageInScope.get()) != null) {
                this.baggageValue = baggage;
                this.httpSpan.tag("country-code", baggage);
            }
            Greeting greeting = new Greeting(message);
            return greeting;
        }
    }

    @Splitter(inputChannel="greetings", outputChannel="words")
    public List<String> words(String greeting) {
        this.splitterSpan = this.tracer.currentSpan();
        return Arrays.asList(StringUtils.delimitedListToStringArray((String)greeting, (String)" "));
    }

    @Aggregator(inputChannel="words", outputChannel="counts")
    public int count(List<String> greeting) {
        this.aggregatorSpan = this.tracer.currentSpan();
        return greeting.size();
    }

    @ServiceActivator(inputChannel="counts")
    public void report(int count) {
        this.serviceActivatorSpan = this.tracer.currentSpan();
        log.info((Object)("Count: " + count));
    }

    public Span getHttpSpan() {
        return this.httpSpan;
    }

    public Span getSplitterSpan() {
        return this.splitterSpan;
    }

    public Span getAggregatorSpan() {
        return this.aggregatorSpan;
    }

    public Span getServiceActivatorSpan() {
        return this.serviceActivatorSpan;
    }

    public String getBaggageValue() {
        return this.baggageValue;
    }

    public List<Span> allSpans() {
        return Arrays.asList(this.httpSpan, this.splitterSpan, this.aggregatorSpan, this.serviceActivatorSpan);
    }
}

